/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MaidInteractWithDoor
extends Task<LivingEntity> {
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 8.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;
    @Nullable
    private PathPoint lastCheckedNode;
    private int remainingCooldown;

    public MaidInteractWithDoor() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_225462_q, (Object)MemoryModuleStatus.REGISTERED));
    }

    protected boolean func_212832_a_(ServerWorld serverWorld, LivingEntity entity) {
        Path path = (Path)entity.func_213375_cj().func_218207_c(MemoryModuleType.field_220954_o).get();
        if (!path.func_242945_b() && !path.func_75879_b()) {
            if (!Objects.equals(this.lastCheckedNode, path.func_237225_h_())) {
                this.remainingCooldown = 20;
                return true;
            }
            if (this.remainingCooldown > 0) {
                --this.remainingCooldown;
            }
            return this.remainingCooldown == 0;
        }
        return false;
    }

    protected void func_212831_a_(ServerWorld serverWorld, LivingEntity entity, long gameTime) {
        DoorBlock doorBlock;
        BlockPos blockPos;
        BlockState blockState;
        Path path = (Path)entity.func_213375_cj().func_218207_c(MemoryModuleType.field_220954_o).get();
        this.lastCheckedNode = path.func_237225_h_();
        PathPoint previousNode = path.func_242950_i();
        PathPoint nextNode = path.func_237225_h_();
        BlockPos blockpos = previousNode.func_224759_a();
        BlockState blockstate = serverWorld.func_180495_p(blockpos);
        if (blockstate.func_235714_a_((ITag)BlockTags.field_200152_g)) {
            DoorBlock doorblock = (DoorBlock)blockstate.func_177230_c();
            if (!doorblock.func_242664_h(blockstate)) {
                doorblock.func_242663_a((World)serverWorld, blockstate, blockpos, true);
            }
            this.rememberDoorToClose(serverWorld, entity, blockpos);
        }
        if ((blockState = serverWorld.func_180495_p(blockPos = nextNode.func_224759_a())).func_235714_a_((ITag)BlockTags.field_200152_g) && !(doorBlock = (DoorBlock)blockState.func_177230_c()).func_242664_h(blockState)) {
            doorBlock.func_242663_a((World)serverWorld, blockState, blockPos, true);
            this.rememberDoorToClose(serverWorld, entity, blockPos);
        }
        MaidInteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(serverWorld, entity, previousNode, nextNode);
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(ServerWorld serverWorld, LivingEntity entity, @Nullable PathPoint pathPoint, @Nullable PathPoint pathPoint1) {
        Brain brain = entity.func_213375_cj();
        if (brain.func_218191_a(MemoryModuleType.field_225462_q)) {
            Iterator iterator = ((Set)brain.func_218207_c(MemoryModuleType.field_225462_q).get()).iterator();
            while (iterator.hasNext()) {
                GlobalPos globalpos = (GlobalPos)iterator.next();
                BlockPos blockpos = globalpos.func_218180_b();
                if (pathPoint != null && pathPoint.func_224759_a().equals((Object)blockpos) || pathPoint1 != null && pathPoint1.func_224759_a().equals((Object)blockpos)) continue;
                if (MaidInteractWithDoor.isDoorTooFarAway(serverWorld, entity, globalpos)) {
                    iterator.remove();
                    continue;
                }
                BlockState blockstate = serverWorld.func_180495_p(blockpos);
                if (!blockstate.func_235714_a_((ITag)BlockTags.field_200152_g)) {
                    iterator.remove();
                    continue;
                }
                DoorBlock doorblock = (DoorBlock)blockstate.func_177230_c();
                if (!doorblock.func_242664_h(blockstate)) {
                    iterator.remove();
                    continue;
                }
                if (MaidInteractWithDoor.areOtherMobsComingThroughDoor(serverWorld, entity, blockpos)) {
                    iterator.remove();
                    continue;
                }
                doorblock.func_242663_a((World)serverWorld, blockstate, blockpos, false);
                iterator.remove();
            }
        }
    }

    private static boolean areOtherMobsComingThroughDoor(ServerWorld serverWorld, LivingEntity entity, BlockPos blockPos) {
        Brain brain = entity.func_213375_cj();
        return brain.func_218191_a(MemoryModuleType.field_220945_f) && ((List)brain.func_218207_c(MemoryModuleType.field_220945_f).get()).stream().filter(livingEntity -> livingEntity.func_200600_R() == entity.func_200600_R()).filter(livingEntity -> blockPos.func_218137_a((IPosition)livingEntity.func_213303_ch(), 2.0)).anyMatch(livingEntity -> MaidInteractWithDoor.isMobComingThroughDoor(serverWorld, livingEntity, blockPos));
    }

    private static boolean isMobComingThroughDoor(ServerWorld serverWorld, LivingEntity entity, BlockPos blockPos) {
        if (!entity.func_213375_cj().func_218191_a(MemoryModuleType.field_220954_o)) {
            return false;
        }
        Path path = (Path)entity.func_213375_cj().func_218207_c(MemoryModuleType.field_220954_o).get();
        if (path.func_75879_b()) {
            return false;
        }
        PathPoint pathpoint = path.func_242950_i();
        if (pathpoint == null) {
            return false;
        }
        PathPoint nextNode = path.func_237225_h_();
        return blockPos.equals((Object)pathpoint.func_224759_a()) || blockPos.equals((Object)nextNode.func_224759_a());
    }

    private static boolean isDoorTooFarAway(ServerWorld serverWorld, LivingEntity entity, GlobalPos globalPos) {
        return globalPos.func_239646_a_() != serverWorld.func_234923_W_() || !globalPos.func_218180_b().func_218137_a((IPosition)entity.func_213303_ch(), 8.0);
    }

    private void rememberDoorToClose(ServerWorld serverWorld, LivingEntity entity, BlockPos blockPos) {
        Brain brain = entity.func_213375_cj();
        GlobalPos globalpos = GlobalPos.func_239648_a_((RegistryKey)serverWorld.func_234923_W_(), (BlockPos)blockPos);
        if (brain.func_218207_c(MemoryModuleType.field_225462_q).isPresent()) {
            ((Set)brain.func_218207_c(MemoryModuleType.field_225462_q).get()).add(globalpos);
        } else {
            brain.func_218205_a(MemoryModuleType.field_225462_q, (Object)Sets.newHashSet((Object[])new GlobalPos[]{globalpos}));
        }
    }
}

