/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidMilkTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 40;
    private final float speedModifier;
    private LivingEntity milkTarget = null;

    public MaidMilkTask(float speedModifier) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(40);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerWorld worldIn, EntityMaid owner) {
        if (super.checkExtraStartConditions(worldIn, owner)) {
            CombinedInvWrapper availableInv = owner.getAvailableInv(true);
            return ItemsUtil.isStackIn((IItemHandler)availableInv, stack -> stack.func_77973_b() == Items.field_151133_ar) && ItemsUtil.isStackIn((IItemHandler)availableInv, stack -> stack == ItemStack.field_190927_a);
        }
        return false;
    }

    protected void start(ServerWorld worldIn, EntityMaid maid, long gameTimeIn) {
        this.milkTarget = null;
        this.getEntities(maid).stream().filter(e -> maid.func_213389_a(e.func_233580_cy_())).filter(Entity::func_70089_S).filter(e -> e instanceof CowEntity).filter(e -> !e.func_70631_g_()).filter(maid::canPathReach).findFirst().ifPresent(e -> {
            this.milkTarget = e;
            BrainUtil.func_233860_a_((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
        });
        if (this.milkTarget != null && this.milkTarget.func_233562_a_((Entity)maid, 2.0)) {
            CombinedInvWrapper availableInv = maid.getAvailableInv(false);
            ItemStack bucket = ItemsUtil.getStack((IItemHandler)availableInv, stack -> stack.func_77973_b() == Items.field_151133_ar);
            if (bucket != ItemStack.field_190927_a) {
                bucket.func_190918_g(1);
                ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)new ItemStack((IItemProvider)Items.field_151117_aB), (boolean)false);
            }
            maid.func_184609_a(Hand.MAIN_HAND);
            maid.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            this.milkTarget = null;
        }
    }

    private List<LivingEntity> getEntities(EntityMaid maid) {
        return maid.func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g).orElse(Lists.newArrayList());
    }
}

