/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public abstract class MaidMoveToBlockTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 120;
    private final float movementSpeed;
    private final int verticalSearchRange;
    protected int verticalSearchStart;

    public MaidMoveToBlockTask(float movementSpeed) {
        this(movementSpeed, 1);
    }

    public MaidMoveToBlockTask(float movementSpeed, int verticalSearchRange) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)InitEntities.TARGET_POS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.movementSpeed = movementSpeed;
        this.verticalSearchRange = verticalSearchRange;
        this.setMaxCheckRate(120);
    }

    protected final void searchForDestination(ServerWorld worldIn, EntityMaid maid) {
        BlockPos centrePos = maid.getBrainSearchPos();
        int searchRange = (int)maid.func_213391_dJ();
        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
        int y = this.verticalSearchStart;
        while (y <= this.verticalSearchRange) {
            for (int i = 0; i < searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        mutableBlockPos.func_239621_a_((Vector3i)centrePos, x, y - 1, z);
                        if (maid.func_213389_a((BlockPos)mutableBlockPos) && this.shouldMoveTo(worldIn, maid, (BlockPos)mutableBlockPos) && this.checkPathReach(maid, (BlockPos)mutableBlockPos) && this.checkOwnerPos(maid, (BlockPos)mutableBlockPos)) {
                            BrainUtil.func_233866_a_((LivingEntity)maid, (BlockPos)mutableBlockPos, (float)this.movementSpeed, (int)0);
                            maid.func_213375_cj().func_218205_a((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosWrapper((BlockPos)mutableBlockPos));
                            this.setNextCheckTickCount(5);
                            return;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
    }

    private boolean checkOwnerPos(EntityMaid maid, BlockPos mutableBlockPos) {
        if (maid.isHomeModeEnable()) {
            return true;
        }
        return maid.func_70902_q() != null && mutableBlockPos.func_218137_a((IPosition)maid.func_70902_q().func_213303_ch(), 8.0);
    }

    protected abstract boolean shouldMoveTo(ServerWorld var1, EntityMaid var2, BlockPos var3);

    protected boolean checkPathReach(EntityMaid maid, BlockPos pos) {
        return maid.canPathReach(pos);
    }
}

