/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.world.server.ServerWorld;

public class MaidPickupEntitiesTask
extends Task<EntityMaid> {
    private final Predicate<EntityMaid> predicate;
    private final float speedModifier;

    public MaidPickupEntitiesTask(float speedModifier) {
        this((Predicate<EntityMaid>)Predicates.alwaysTrue(), speedModifier);
    }

    public MaidPickupEntitiesTask(Predicate<EntityMaid> predicate, float speedModifier) {
        super((Map)ImmutableMap.of((Object)InitEntities.VISIBLE_PICKUP_ENTITIES.get(), (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.predicate = predicate;
        this.speedModifier = speedModifier;
    }

    protected boolean checkExtraStartConditions(ServerWorld worldIn, EntityMaid owner) {
        return owner.func_70909_n() && this.predicate.test(owner);
    }

    protected void start(ServerWorld worldIn, EntityMaid maid, long gameTimeIn) {
        this.getItems(maid).stream().filter(e -> maid.func_213389_a(e.func_233580_cy_()) && e.func_70089_S() && !e.func_70090_H()).filter(maid::canPathReach).findFirst().ifPresent(e -> BrainUtil.func_233860_a_((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0));
    }

    private List<Entity> getItems(EntityMaid maid) {
        return maid.func_213375_cj().func_218207_c((MemoryModuleType)InitEntities.VISIBLE_PICKUP_ENTITIES.get()).orElse(Lists.newArrayList());
    }
}

