/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;

public class MaidShearTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private LivingEntity shearableEntity = null;

    public MaidShearTask(float speedModifier) {
        super((Map<MemoryModuleType<?>, MemoryModuleStatus>)ImmutableMap.of((Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(12);
    }

    protected void start(ServerWorld worldIn, EntityMaid maid, long gameTimeIn) {
        ItemStack mainhandItem = maid.func_184614_ca();
        this.shearableEntity = null;
        this.getEntities(maid).stream().filter(e -> maid.func_213389_a(e.func_233580_cy_())).filter(Entity::func_70089_S).filter(e -> e instanceof IForgeShearable).filter(e -> ((IForgeShearable)e).isShearable(mainhandItem, maid.field_70170_p, e.func_233580_cy_())).filter(maid::canPathReach).findFirst().ifPresent(e -> {
            this.shearableEntity = e;
            BrainUtil.func_233860_a_((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
        });
        if (this.shearableEntity != null && this.shearableEntity.func_233562_a_((Entity)maid, 2.0)) {
            Random rand = maid.func_70681_au();
            int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)mainhandItem);
            List drops = ((IForgeShearable)this.shearableEntity).onSheared(null, mainhandItem, maid.field_70170_p, this.shearableEntity.func_233580_cy_(), level);
            drops.forEach(stack -> {
                ItemEntity itemEntity = this.shearableEntity.func_70099_a(stack, 1.0f);
                if (itemEntity != null) {
                    itemEntity.func_213317_d(itemEntity.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                }
            });
            maid.func_184609_a(Hand.MAIN_HAND);
            mainhandItem.func_222118_a(1, (LivingEntity)maid, entityMaid -> entityMaid.func_213334_d(Hand.MAIN_HAND));
            this.shearableEntity = null;
        }
    }

    private List<LivingEntity> getEntities(EntityMaid maid) {
        return maid.func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g).orElse(Lists.newArrayList());
    }
}

