/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.BowItem;
import net.minecraft.item.ShootableItem;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;

public class MaidShootTargetTask
extends Task<EntityMaid> {
    private final int attackCooldown;
    private int attackTime = -1;
    private int seeTime;

    public MaidShootTargetTask(int attackCooldown) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT), 1200);
        this.attackCooldown = attackCooldown;
    }

    protected boolean checkExtraStartConditions(ServerWorld worldIn, EntityMaid owner) {
        Optional memory = owner.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        if (memory.isPresent()) {
            LivingEntity target = (LivingEntity)memory.get();
            return owner.func_233634_a_(item -> item instanceof ShootableItem) && BrainUtil.func_233876_c_((LivingEntity)owner, (LivingEntity)target) && BrainUtil.func_233869_a_((MobEntity)owner, (LivingEntity)target, (int)0);
        }
        return false;
    }

    protected boolean canStillUse(ServerWorld worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(ServerWorld worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void tick(ServerWorld worldIn, EntityMaid owner, long gameTime) {
        owner.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).ifPresent(target -> {
            boolean seeTimeMoreThanZero;
            boolean canSee = BrainUtil.func_233876_c_((LivingEntity)owner, (LivingEntity)target);
            boolean bl = seeTimeMoreThanZero = this.seeTime > 0;
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (owner.func_184587_cr()) {
                int ticksUsingItem;
                if (!canSee && this.seeTime < -60) {
                    owner.func_184602_cy();
                } else if (canSee && (ticksUsingItem = owner.func_184612_cw()) >= 20) {
                    owner.func_184602_cy();
                    owner.func_82196_d((LivingEntity)target, BowItem.func_185059_b((int)ticksUsingItem));
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                owner.func_184598_c(Hand.MAIN_HAND);
            }
        });
    }

    protected void stop(ServerWorld worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.seeTime = 0;
        this.attackTime = -1;
        entityIn.func_184602_cy();
    }
}

