/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.Items;
import net.minecraft.item.SnowballItem;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;

public class MaidSnowballTargetTask
extends Task<EntityMaid> {
    private static final float CHANCE_STOPPING = 0.03125f;
    private final int attackCooldown;
    private boolean canThrow = false;
    private int attackTime = -1;

    public MaidSnowballTargetTask(int attackCooldown) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT), 1200);
        this.attackCooldown = attackCooldown;
    }

    protected boolean checkExtraStartConditions(ServerWorld worldIn, EntityMaid owner) {
        Optional memory = owner.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        if (memory.isPresent()) {
            LivingEntity target = (LivingEntity)memory.get();
            return owner.func_233634_a_(item -> item instanceof SnowballItem || item == Items.field_190931_a) && BrainUtil.func_233876_c_((LivingEntity)owner, (LivingEntity)target) && this.inMaxDistance(owner);
        }
        return false;
    }

    protected boolean canStillUse(ServerWorld worldIn, EntityMaid entityIn, long gameTimeIn) {
        return this.chanceStop((LivingEntity)entityIn) && entityIn.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_) && this.isCurrentTargetInSameLevel((LivingEntity)entityIn) && this.isCurrentTargetAlive((LivingEntity)entityIn) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(ServerWorld worldIn, EntityMaid entityIn, long gameTimeIn) {
        if (entityIn.func_184614_ca().func_190926_b()) {
            entityIn.func_184611_a(Hand.MAIN_HAND, Items.field_151126_ay.func_190903_i());
            return;
        }
        if (!(entityIn.func_184614_ca().func_77973_b() instanceof SnowballItem) && entityIn.func_184592_cb().func_190926_b()) {
            entityIn.func_184611_a(Hand.OFF_HAND, Items.field_151126_ay.func_190903_i());
        }
    }

    protected void tick(ServerWorld worldIn, EntityMaid owner, long gameTime) {
        owner.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).ifPresent(target -> {
            boolean canSee = BrainUtil.func_233876_c_((LivingEntity)owner, (LivingEntity)target);
            if (this.canThrow && canSee) {
                this.canThrow = false;
                if (owner.func_184614_ca().func_77973_b() instanceof SnowballItem) {
                    owner.func_184609_a(Hand.MAIN_HAND);
                } else {
                    owner.func_184609_a(Hand.OFF_HAND);
                }
                BrainUtil.func_220625_c((LivingEntity)owner, (LivingEntity)target);
                this.performRangedAttack(owner, (LivingEntity)target);
                this.attackTime = this.attackCooldown + owner.func_70681_au().nextInt(this.attackCooldown);
            } else if (--this.attackTime <= 0) {
                this.canThrow = true;
            }
        });
    }

    private void performRangedAttack(EntityMaid shooter, LivingEntity target) {
        SnowballEntity snowball = new SnowballEntity(shooter.field_70170_p, (LivingEntity)shooter);
        double x = target.func_226277_ct_() - shooter.func_226277_ct_();
        double y = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - snowball.func_213303_ch().field_72448_b;
        double z = target.func_226281_cx_() - shooter.func_226281_cx_();
        double pitch = (double)MathHelper.func_76133_a((double)(x * x + z * z)) * 0.15;
        snowball.func_70186_c(x, y + pitch, z, 1.6f, 1.0f);
        shooter.func_184185_a(SoundEvents.field_187797_fA, 0.5f, 0.4f / (shooter.func_70681_au().nextFloat() * 0.4f + 0.8f));
        shooter.field_70170_p.func_217376_c((Entity)snowball);
    }

    protected void stop(ServerWorld worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.attackTime = -1;
        this.canThrow = false;
        this.clearAttackTarget((LivingEntity)entityIn);
    }

    private boolean isCurrentTargetInSameLevel(LivingEntity entity) {
        Optional optional = entity.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        return optional.isPresent() && ((LivingEntity)optional.get()).field_70170_p == entity.field_70170_p;
    }

    private boolean isCurrentTargetAlive(LivingEntity entity) {
        Optional optional = entity.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        return optional.isPresent() && ((LivingEntity)optional.get()).func_70089_S();
    }

    private boolean inMaxDistance(EntityMaid maid) {
        Optional optional = maid.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        return optional.isPresent() && maid.func_213389_a(((LivingEntity)optional.get()).func_233580_cy_());
    }

    private boolean chanceStop(LivingEntity entity) {
        return entity.func_70681_au().nextFloat() > 0.03125f;
    }

    private void clearAttackTarget(LivingEntity entity) {
        entity.func_213375_cj().func_218189_b(MemoryModuleType.field_234103_o_);
    }
}

