/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidTorchPlaceTask
extends Task<EntityMaid> {
    private final double closeEnoughDist;

    public MaidTorchPlaceTask(double closeEnoughDist) {
        super((Map)ImmutableMap.of((Object)InitEntities.TARGET_POS.get(), (Object)MemoryModuleStatus.VALUE_PRESENT));
        this.closeEnoughDist = closeEnoughDist;
    }

    protected boolean checkExtraStartConditions(ServerWorld worldIn, EntityMaid owner) {
        Brain<EntityMaid> brain = owner.func_213375_cj();
        return brain.func_218207_c((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            Vector3d targetV3d = targetPos.func_220609_b();
            if (owner.func_195048_a(targetV3d) > Math.pow(this.closeEnoughDist, 2.0)) {
                Optional walkTarget = brain.func_218207_c(MemoryModuleType.field_220950_k);
                if (!walkTarget.isPresent() || !((WalkTarget)walkTarget.get()).func_220966_a().func_220609_b().equals((Object)targetV3d)) {
                    brain.func_218189_b((MemoryModuleType)InitEntities.TARGET_POS.get());
                }
                return false;
            }
            return true;
        }).orElse(false);
    }

    protected void start(ServerWorld world, EntityMaid maid, long gameTimeIn) {
        maid.func_213375_cj().func_218207_c((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> {
            ItemStack torch = this.getTorchItem(maid);
            if (!torch.func_190926_b()) {
                BlockPos pos = posWrapper.func_220608_a().func_177984_a();
                BlockState torchState = Blocks.field_150478_aa.func_176223_P();
                world.func_180501_a(pos, torchState, 11);
                SoundType soundType = torchState.getSoundType((IWorldReader)world, pos, (Entity)maid);
                world.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                torch.func_190918_g(1);
                maid.func_184609_a(Hand.MAIN_HAND);
                maid.func_213375_cj().func_218189_b((MemoryModuleType)InitEntities.TARGET_POS.get());
                maid.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
            }
        });
    }

    private ItemStack getTorchItem(EntityMaid entityMaid) {
        CombinedInvWrapper itemHandler = entityMaid.getAvailableInv(false);
        return ItemsUtil.getStack((IItemHandler)itemHandler, stack -> stack.func_77973_b() == Items.field_221657_bQ);
    }
}

