/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class SetWalkTargetAwayFrom<T>
extends Task<CreatureEntity> {
    private final MemoryModuleType<T> walkAwayFromMemory;
    private final float speedModifier;
    private final Function<T, Vector3d> toPosition;

    public SetWalkTargetAwayFrom(MemoryModuleType<T> walkAwayFromMemory, float speedModifier, boolean ignoreOtherWalkTarget, Function<T, Vector3d> toPosition) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)(ignoreOtherWalkTarget ? MemoryModuleStatus.REGISTERED : MemoryModuleStatus.VALUE_ABSENT), walkAwayFromMemory, (Object)MemoryModuleStatus.VALUE_PRESENT));
        this.walkAwayFromMemory = walkAwayFromMemory;
        this.speedModifier = speedModifier;
        this.toPosition = toPosition;
    }

    public static SetWalkTargetAwayFrom<BlockPos> pos(MemoryModuleType<BlockPos> walkAwayFromMemory, float speedModifier, boolean ignoreOtherWalkTarget) {
        return new SetWalkTargetAwayFrom<BlockPos>(walkAwayFromMemory, speedModifier, ignoreOtherWalkTarget, Vector3d::func_237492_c_);
    }

    public static SetWalkTargetAwayFrom<? extends Entity> entity(MemoryModuleType<? extends Entity> walkAwayFromMemory, float speedModifier, boolean ignoreOtherWalkTarget) {
        return new SetWalkTargetAwayFrom<Entity>(walkAwayFromMemory, speedModifier, ignoreOtherWalkTarget, Entity::func_213303_ch);
    }

    protected boolean checkExtraStartConditions(ServerWorld serverWorld, CreatureEntity creature) {
        int radius = (int)creature.func_213391_dJ();
        return !this.alreadyWalkingAwayFromPosWithSameSpeed(creature) && creature.func_213303_ch().func_237488_a_((IPosition)this.getPosToAvoid(creature), (double)radius);
    }

    private Vector3d getPosToAvoid(CreatureEntity creature) {
        return this.toPosition.apply(creature.func_213375_cj().func_218207_c(this.walkAwayFromMemory).get());
    }

    private boolean alreadyWalkingAwayFromPosWithSameSpeed(CreatureEntity creature) {
        Vector3d vector3d;
        if (!creature.func_213375_cj().func_218191_a(MemoryModuleType.field_220950_k)) {
            return false;
        }
        WalkTarget walktarget = (WalkTarget)creature.func_213375_cj().func_218207_c(MemoryModuleType.field_220950_k).get();
        if (walktarget.func_220965_b() != this.speedModifier) {
            return false;
        }
        Vector3d subtract = walktarget.func_220966_a().func_220609_b().func_178788_d(creature.func_213303_ch());
        return subtract.func_72430_b(vector3d = this.getPosToAvoid(creature).func_178788_d(creature.func_213303_ch())) < 0.0;
    }

    protected void start(ServerWorld pLevel, CreatureEntity pEntity, long pGameTime) {
        SetWalkTargetAwayFrom.moveAwayFrom(pEntity, this.getPosToAvoid(pEntity), this.speedModifier);
    }

    private static void moveAwayFrom(CreatureEntity creature, Vector3d vec, float speedModifier) {
        int radius = (int)creature.func_213391_dJ();
        for (int i = 0; i < 10; ++i) {
            Vector3d vector3d = RandomPositionGenerator.func_223548_b((CreatureEntity)creature, (int)radius, (int)7, (Vector3d)vec);
            if (vector3d == null) continue;
            creature.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget(vector3d, speedModifier, 0));
            return;
        }
    }
}

