/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.goal;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;

public class MaidTemptGoal
extends Goal {
    private static final EntityPredicate TEMP_TARGETING = new EntityPredicate().func_221013_a(10.0).func_221008_a().func_221011_b().func_221009_d().func_221014_c();
    protected final CreatureEntity mob;
    private final double speedModifier;
    private final Ingredient items;
    private final boolean canScare;
    protected EntityMaid maid;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    private int calmDown;
    private boolean isRunning;

    public MaidTemptGoal(CreatureEntity creature, double speedModifier, Ingredient ingredient, boolean canScare) {
        this(creature, speedModifier, canScare, ingredient);
    }

    public MaidTemptGoal(CreatureEntity creature, double speedModifier, boolean canScare, Ingredient ingredient) {
        this.mob = creature;
        this.speedModifier = speedModifier;
        this.items = ingredient;
        this.canScare = canScare;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(creature.func_70661_as() instanceof GroundPathNavigator) && !(creature.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal: " + Objects.requireNonNull(creature.func_200600_R().getRegistryName()));
        }
    }

    public static boolean checkNavigation(CreatureEntity creature) {
        return creature.func_70661_as() instanceof GroundPathNavigator || creature.func_70661_as() instanceof FlyingPathNavigator;
    }

    public boolean func_75250_a() {
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.maid = (EntityMaid)this.mob.field_70170_p.func_217360_a(EntityMaid.class, TEMP_TARGETING, (LivingEntity)this.mob, this.mob.func_226277_ct_(), this.mob.func_226278_cu_(), this.mob.func_226281_cx_(), this.mob.func_174813_aQ().func_186662_g(10.0));
        if (this.maid == null) {
            return false;
        }
        return this.shouldFollowItem(this.maid.func_184614_ca()) || this.shouldFollowItem(this.maid.func_184592_cb());
    }

    protected boolean shouldFollowItem(ItemStack itemStack) {
        return this.items.test(itemStack);
    }

    public boolean func_75253_b() {
        if (this.canScare()) {
            if (this.mob.func_70068_e((Entity)this.maid) < 36.0) {
                if (this.maid.func_70092_e(this.px, this.py, this.pz) > 0.01) {
                    return false;
                }
                if (Math.abs((double)this.maid.field_70125_A - this.pRotX) > 5.0 || Math.abs((double)this.maid.field_70177_z - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = this.maid.func_226277_ct_();
                this.py = this.maid.func_226278_cu_();
                this.pz = this.maid.func_226281_cx_();
            }
            this.pRotX = this.maid.field_70125_A;
            this.pRotY = this.maid.field_70177_z;
        }
        return this.func_75250_a();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    public void func_75249_e() {
        this.px = this.maid.func_226277_ct_();
        this.py = this.maid.func_226278_cu_();
        this.pz = this.maid.func_226281_cx_();
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.maid = null;
        this.mob.func_70661_as().func_75499_g();
        this.calmDown = 100;
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.mob.func_70671_ap().func_75651_a((Entity)this.maid, (float)(this.mob.func_184649_cE() + 20), (float)this.mob.func_70646_bf());
        if (this.mob.func_70068_e((Entity)this.maid) < 6.25) {
            this.mob.func_70661_as().func_75499_g();
        } else {
            this.mob.func_70661_as().func_75497_a((Entity)this.maid, this.speedModifier);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

