/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.model.backpack.BigBackpackModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.BigBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;

public class BigBackpack
extends IMaidBackpack {
    public static final ResourceLocation ID = new ResourceLocation("touhou_little_maid", "big_backpack");

    @Override
    public void onPutOn(ItemStack stack, PlayerEntity player, EntityMaid maid) {
    }

    @Override
    public void onTakeOff(ItemStack stack, PlayerEntity player, EntityMaid maid) {
        Item item = stack.func_77973_b();
        if (item == InitItems.MAID_BACKPACK_SMALL.get()) {
            ItemsUtil.dropEntityItems((Entity)maid, (IItemHandler)maid.getMaidInv(), 12);
            return;
        }
        if (item == InitItems.MAID_BACKPACK_MIDDLE.get()) {
            ItemsUtil.dropEntityItems((Entity)maid, (IItemHandler)maid.getMaidInv(), 24);
            return;
        }
        if (item == InitItems.MAID_BACKPACK_BIG.get()) {
            return;
        }
        this.dropAllItems(maid);
    }

    @Override
    public void onSpawnTombstone(EntityMaid maid, EntityTombstone tombstone) {
    }

    @Override
    public INamedContainerProvider getGuiProvider(final int entityId) {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Maid Big Container");
            }

            @Nullable
            public Container createMenu(int index, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new BigBackpackContainer(index, playerInventory, entityId);
            }
        };
    }

    @Override
    public int getAvailableMaxContainerIndex() {
        return 36;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public EntityModel<EntityMaid> getBackpackModel() {
        return new BigBackpackModel();
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getBackpackTexture() {
        return new ResourceLocation("touhou_little_maid", "textures/entity/maid_backpack_big.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void offsetBackpackItem(MatrixStack poseStack) {
        poseStack.func_227861_a_(0.0, 0.0, -0.4);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Item getItem() {
        return (Item)InitItems.MAID_BACKPACK_BIG.get();
    }
}

