/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.model.backpack.TankBackpackModel;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.TankBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.item.ItemTankBackpack;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TankBackpack
extends IMaidBackpack {
    public static final ResourceLocation ID = new ResourceLocation("touhou_little_maid", "tank");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Item getItem() {
        return (Item)InitItems.TANK_BACKPACK.get();
    }

    @Override
    public void onPutOn(ItemStack stack, PlayerEntity player, EntityMaid maid) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData) {
            TankBackpackData tankBackpackData = (TankBackpackData)backpackData;
            ItemTankBackpack.setTankBackpack(maid, tankBackpackData, stack);
        }
    }

    @Override
    public void onTakeOff(ItemStack stack, PlayerEntity player, EntityMaid maid) {
        Item item;
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData) {
            TankBackpackData tankBackpackData = (TankBackpackData)backpackData;
            InvWrapper inv = new InvWrapper((IInventory)tankBackpackData);
            ItemsUtil.dropEntityItems((Entity)maid, (IItemHandler)inv);
        }
        if ((item = stack.func_77973_b()) == InitItems.MAID_BACKPACK_SMALL.get()) {
            ItemsUtil.dropEntityItems((Entity)maid, (IItemHandler)maid.getMaidInv(), 12);
            return;
        }
        if (item == InitItems.MAID_BACKPACK_MIDDLE.get() || item == InitItems.MAID_BACKPACK_BIG.get()) {
            return;
        }
        this.dropAllItems(maid);
    }

    @Override
    public ItemStack getTakeOffItemStack(ItemStack stack, @Nullable PlayerEntity player, EntityMaid maid) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData) {
            TankBackpackData tankBackpackData = (TankBackpackData)backpackData;
            return ItemTankBackpack.getTankBackpack(tankBackpackData);
        }
        return super.getTakeOffItemStack(stack, player, maid);
    }

    @Override
    public void onSpawnTombstone(EntityMaid maid, EntityTombstone tombstone) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof TankBackpackData) {
            TankBackpackData tankBackpackData = (TankBackpackData)backpackData;
            InvWrapper inv = new InvWrapper((IInventory)tankBackpackData);
            for (int i = 0; i < inv.getSlots(); ++i) {
                int size = inv.getSlotLimit(i);
                tombstone.insertItem(inv.extractItem(i, size, false));
            }
        }
    }

    @Override
    public boolean hasBackpackData() {
        return true;
    }

    @Override
    @Nullable
    public IBackpackData getBackpackData(EntityMaid maid) {
        return new TankBackpackData(maid);
    }

    @Override
    public INamedContainerProvider getGuiProvider(final int entityId) {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Maid Tank Container");
            }

            public AbstractMaidContainer createMenu(int index, PlayerInventory playerInventory, PlayerEntity player) {
                return new TankBackpackContainer(index, playerInventory, entityId);
            }
        };
    }

    @Override
    public int getAvailableMaxContainerIndex() {
        return 18;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public EntityModel<EntityMaid> getBackpackModel() {
        return new TankBackpackModel();
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getBackpackTexture() {
        return new ResourceLocation("touhou_little_maid", "textures/entity/tank_backpack.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void offsetBackpackItem(MatrixStack poseStack) {
        poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-7.5f));
        poseStack.func_227861_a_(0.0, 0.625, -0.25);
    }
}

