/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack.data;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class FurnaceBackpackData
extends Inventory
implements IBackpackData {
    private static final int INPUT_INDEX = 0;
    private static final int FUEL_INDEX = 1;
    private static final int OUTPUT_INDEX = 2;
    private final World level;
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return FurnaceBackpackData.this.litTime;
                }
                case 1: {
                    return FurnaceBackpackData.this.litDuration;
                }
                case 2: {
                    return FurnaceBackpackData.this.cookingProgress;
                }
                case 3: {
                    return FurnaceBackpackData.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    FurnaceBackpackData.this.litTime = value;
                    break;
                }
                case 1: {
                    FurnaceBackpackData.this.litDuration = value;
                    break;
                }
                case 2: {
                    FurnaceBackpackData.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    FurnaceBackpackData.this.cookingTotalTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };

    public FurnaceBackpackData(EntityMaid maid) {
        super(3);
        this.level = maid.field_70170_p;
    }

    @Override
    public IIntArray getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public void load(CompoundNBT tag, EntityMaid maid) {
        this.litTime = tag.func_74762_e("BurnTime");
        this.cookingProgress = tag.func_74762_e("CookTime");
        this.cookingTotalTime = tag.func_74762_e("CookTimeTotal");
        this.litDuration = this.getBurnDuration(this.func_70301_a(1));
        this.func_70486_a(tag.func_150295_c("Items", 10));
    }

    @Override
    public void save(CompoundNBT tag, EntityMaid maid) {
        tag.func_74768_a("BurnTime", this.litTime);
        tag.func_74768_a("CookTime", this.cookingProgress);
        tag.func_74768_a("CookTimeTotal", this.cookingTotalTime);
        tag.func_218657_a("Items", (INBT)this.func_70487_g());
    }

    @Override
    public void serverTick(EntityMaid maid) {
        boolean readyForLit;
        World level = maid.field_70170_p;
        if (this.isLit()) {
            --this.litTime;
        }
        ItemStack fuelItem = this.func_70301_a(1);
        boolean inputNotEmpty = !this.func_70301_a(0).func_190926_b();
        boolean fuelNotEmpty = !fuelItem.func_190926_b();
        boolean bl = readyForLit = inputNotEmpty && fuelNotEmpty;
        if (this.isLit() || readyForLit) {
            FurnaceRecipe recipe = this.level.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)this, this.level).orElse(null);
            int maxStackSize = this.func_70297_j_();
            if (!this.isLit() && this.canBurn(recipe, this, maxStackSize)) {
                this.litDuration = this.litTime = this.getBurnDuration(fuelItem);
                if (this.isLit()) {
                    if (fuelItem.hasContainerItem()) {
                        this.func_70299_a(1, fuelItem.getContainerItem());
                    } else if (fuelNotEmpty) {
                        fuelItem.func_190918_g(1);
                        if (fuelItem.func_190926_b()) {
                            this.func_70299_a(1, fuelItem.getContainerItem());
                        }
                    }
                }
            }
            if (this.isLit() && this.canBurn(recipe, this, maxStackSize)) {
                ++this.cookingProgress;
                if (this.cookingProgress == this.cookingTotalTime) {
                    this.cookingProgress = 0;
                    this.cookingTotalTime = this.getTotalCookTime(level);
                    if (this.burn(recipe, this, maxStackSize)) {
                        int exp = this.createExperience(recipe.func_222138_b());
                        maid.setExperience(maid.getExperience() + exp);
                    }
                }
            } else {
                this.cookingProgress = 0;
            }
        } else if (this.cookingProgress > 0) {
            this.cookingProgress = MathHelper.func_76125_a((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack slotItem = this.func_70301_a(index);
        boolean isSameItem = !stack.func_190926_b() && ItemStack.func_77970_a((ItemStack)slotItem, (ItemStack)stack);
        super.func_70299_a(index, stack);
        if (index == 0 && !isSameItem) {
            this.cookingTotalTime = this.getTotalCookTime(this.level);
            this.cookingProgress = 0;
        }
    }

    private int createExperience(float recipeExp) {
        int integer = MathHelper.func_76141_d((float)recipeExp);
        float decimal = MathHelper.func_226164_h_((float)recipeExp);
        if (decimal != 0.0f && Math.random() < (double)decimal) {
            ++integer;
        }
        return integer;
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    private int getBurnDuration(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)fuel, (IRecipeType)IRecipeType.field_222150_b);
    }

    private boolean canBurn(@Nullable FurnaceRecipe recipe, Inventory container, int maxStackSize) {
        if (!container.func_70301_a(0).func_190926_b() && recipe != null) {
            ItemStack result = recipe.func_77572_b((IInventory)this);
            if (result.func_190926_b()) {
                return false;
            }
            ItemStack output = container.func_70301_a(2);
            if (output.func_190926_b()) {
                return true;
            }
            if (!output.func_77969_a(result)) {
                return false;
            }
            if (output.func_190916_E() + result.func_190916_E() <= maxStackSize && output.func_190916_E() + result.func_190916_E() <= output.func_77976_d()) {
                return true;
            }
            return output.func_190916_E() + result.func_190916_E() <= result.func_77976_d();
        }
        return false;
    }

    private boolean burn(@Nullable FurnaceRecipe recipe, Inventory container, int maxStackSize) {
        if (recipe != null && this.canBurn(recipe, container, maxStackSize)) {
            ItemStack input = container.func_70301_a(0);
            ItemStack result = recipe.func_77572_b((IInventory)this);
            ItemStack output = container.func_70301_a(2);
            if (output.func_190926_b()) {
                container.func_70299_a(2, result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            if (input.func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !container.func_70301_a(1).func_190926_b() && container.func_70301_a(1).func_77973_b() == Items.field_151133_ar) {
                container.func_70299_a(1, new ItemStack((IItemProvider)Items.field_151131_as));
            }
            input.func_190918_g(1);
            return true;
        }
        return false;
    }

    private int getTotalCookTime(World level) {
        return level.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)this, level).map(AbstractCookingRecipe::func_222137_e).orElse(200);
    }
}

