/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack.data;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.MaidFluidUtil;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IIntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TankBackpackData
extends Inventory
implements IBackpackData {
    public static final int CAPACITY = 10000;
    private static final int INPUT_INDEX = 0;
    private static final int OUTPUT_INDEX = 1;
    private final EntityMaid maid;
    private final FluidTank tank = new FluidTank(10000);
    private final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int index) {
            if (index == 0) {
                return TankBackpackData.this.tankFluidCount;
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            if (index == 0) {
                TankBackpackData.this.tankFluidCount = value;
            }
        }

        public int func_221478_a() {
            return 1;
        }
    };
    private int tankFluidCount = 0;

    public TankBackpackData(EntityMaid maid) {
        super(2);
        this.maid = maid;
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    public IIntArray getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public void load(CompoundNBT tag, EntityMaid maid) {
        this.loadTank(tag.func_74775_l("Tanks"), maid);
        this.func_70486_a(tag.func_150295_c("Items", 10));
    }

    @Override
    public void save(CompoundNBT tag, EntityMaid maid) {
        tag.func_218657_a("Tanks", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        tag.func_218657_a("Items", (INBT)this.func_70487_g());
    }

    @Override
    public void serverTick(EntityMaid maid) {
        ItemStack outputStack;
        boolean shouldUpdate = false;
        ItemStack inputStack = this.func_70301_a(0);
        if (!inputStack.func_190926_b() && this.tank.getFluidAmount() < 10000) {
            CombinedInvWrapper availableInv = this.maid.getAvailableInv(false);
            MaidFluidUtil.bucketToTank(inputStack, (IFluidHandler)this.tank, (IItemHandler)availableInv);
            this.func_70299_a(0, inputStack);
            shouldUpdate = true;
        }
        if (!(outputStack = this.func_70301_a(1)).func_190926_b() && 0 < this.tank.getFluidAmount()) {
            CombinedInvWrapper availableInv = this.maid.getAvailableInv(false);
            MaidFluidUtil.tankToBucket(outputStack, (IFluidHandler)this.tank, (IItemHandler)availableInv);
            this.func_70299_a(1, outputStack);
            shouldUpdate = true;
        }
        if (shouldUpdate) {
            this.tankFluidCount = this.tank.getFluidAmount();
            ResourceLocation key = ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.tank.getFluid().getFluid());
            if (key != null) {
                maid.setBackpackFluid(key.toString());
            }
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void loadTank(CompoundNBT nbt, EntityMaid maid) {
        this.tank.readFromNBT(nbt);
        this.tankFluidCount = this.tank.getFluidAmount();
        ResourceLocation key = ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.tank.getFluid().getFluid());
        if (key != null) {
            maid.setBackpackFluid(key.toString());
        }
    }
}

