/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatTextType;
import com.github.tartaricacid.touhoulittlemaid.util.DataUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public final class ChatText {
    public static final ResourceLocation EMPTY_ICON_PATH = new ResourceLocation("touhou_little_maid", "empty");
    public static final ChatText EMPTY_CHAT_TEXT = new ChatText(ChatTextType.EMPTY, EMPTY_ICON_PATH, "");
    private static final String ICON_IDENTIFIER_CHAR = "%";
    private final ChatTextType type;
    private final ResourceLocation iconPath;
    private final String text;

    public ChatText(ChatTextType type, ResourceLocation iconPath, String text) {
        this.type = type;
        this.iconPath = iconPath;
        this.text = text;
    }

    public static void toBuff(ChatText chatText, PacketBuffer buf) {
        buf.func_179249_a((Enum)chatText.type);
        buf.func_192572_a(chatText.iconPath);
        buf.func_180714_a(chatText.text);
    }

    public static ChatText fromBuff(PacketBuffer buf) {
        ChatTextType type = (ChatTextType)buf.func_179257_a(ChatTextType.class);
        ResourceLocation iconPath = buf.func_192575_l();
        String text = buf.func_218666_n();
        return new ChatText(type, iconPath, text);
    }

    public boolean isText() {
        return this.type == ChatTextType.TEXT;
    }

    public boolean isIcon() {
        return this.type == ChatTextType.ICON;
    }

    public ResourceLocation getIconPath() {
        return this.iconPath;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChatText)) {
            return false;
        }
        ChatText chatText = (ChatText)obj;
        return this.type.equals((Object)chatText.type) && this.iconPath.equals((Object)chatText.iconPath) && this.text.equals(chatText.text);
    }

    public static class Serializer
    implements JsonDeserializer<ChatText> {
        public ChatText deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String text = JSONUtils.func_151206_a((JsonElement)json, (String)"chat_text");
            if (StringUtils.isEmpty((CharSequence)text)) {
                return EMPTY_CHAT_TEXT;
            }
            if (text.startsWith(ChatText.ICON_IDENTIFIER_CHAR) && text.endsWith(ChatText.ICON_IDENTIFIER_CHAR)) {
                String substring = text.substring(1, text.length() - 1);
                if (DataUtils.isValidResourceLocation(substring)) {
                    return new ChatText(ChatTextType.ICON, new ResourceLocation(substring), "");
                }
                return EMPTY_CHAT_TEXT;
            }
            return new ChatText(ChatTextType.TEXT, EMPTY_ICON_PATH, text);
        }
    }
}

