/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatTextType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import org.apache.commons.lang3.StringUtils;

public class MaidScriptBookManager {
    private static final Gson GSON = new Gson();
    private static final String STORE_TAG = "MaidScriptBook";
    private static final String PAGES_TAG = "pages";
    private static final String SEPARATOR = "\n\n";
    private final Map<String, List<ChatText>> scripts = Maps.newHashMap();
    private ListNBT scriptsTags = new ListNBT();

    public boolean installScript(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_150297_b(PAGES_TAG, 9)) {
            return false;
        }
        ListNBT pagesTag = tag.func_150295_c(PAGES_TAG, 8);
        if (pagesTag.isEmpty()) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151164_bB) {
            ListNBT list = pagesTag.func_74737_b();
            this.scriptsTags = new ListNBT();
            for (int i = 0; i < list.size(); ++i) {
                BookText bookText = (BookText)GSON.fromJson(list.func_150307_f(i), BookText.class);
                this.scriptsTags.add((Object)StringNBT.func_229705_a_((String)bookText.text));
            }
        } else {
            this.scriptsTags = pagesTag.func_74737_b();
        }
        this.loadFromTag(this.scriptsTags);
        return true;
    }

    public void removeScript() {
        this.scripts.clear();
        this.scriptsTags = new ListNBT();
    }

    public boolean copyScript(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_150297_b(PAGES_TAG, 9) || tag.func_150295_c(PAGES_TAG, 8).isEmpty()) {
            CompoundNBT stackTag = stack.func_196082_o();
            stackTag.func_218657_a(PAGES_TAG, (INBT)this.scriptsTags.func_74737_b());
            return true;
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundNBT compound) {
        compound.func_218657_a(STORE_TAG, (INBT)this.scriptsTags);
    }

    public void readAdditionalSaveData(CompoundNBT compound) {
        if (compound.func_150297_b(STORE_TAG, 9)) {
            this.scriptsTags = compound.func_150295_c(STORE_TAG, 8);
            this.loadFromTag(this.scriptsTags);
        }
    }

    private void loadFromTag(ListNBT pages) {
        this.scripts.clear();
        for (int i = 0; i < pages.size(); ++i) {
            String type;
            String pageText = pages.func_150307_f(i);
            String[] split = StringUtils.split((String)pageText, (String)SEPARATOR);
            if (split.length < 2 || StringUtils.isBlank((CharSequence)(type = StringUtils.strip((String)split[0]).toLowerCase(Locale.US)))) continue;
            List scriptList = this.scripts.computeIfAbsent(type, k -> Lists.newArrayList());
            for (int j = 1; j < split.length; ++j) {
                String script = StringUtils.strip((String)split[j]);
                if (!StringUtils.isNotBlank((CharSequence)script)) continue;
                ChatText chatText = new ChatText(ChatTextType.TEXT, ChatText.EMPTY_ICON_PATH, script);
                scriptList.add(chatText);
            }
        }
    }

    public List<ChatText> getScripts(String type) {
        return this.scripts.getOrDefault(type, Lists.newArrayList());
    }

    private static class BookText {
        @SerializedName(value="text")
        private String text;

        private BookText() {
        }
    }
}

