/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.favorability;

import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;

public class FavorabilityManager {
    public static final Map<String, Type> TYPES = Maps.newHashMap();
    private static final int LEVEL_0 = 0;
    private static final int LEVEL_1 = 1;
    private static final int LEVEL_2 = 2;
    private static final int LEVEL_3 = 3;
    private static final int LEVEL_0_POINT = 0;
    private static final int LEVEL_1_POINT = 64;
    private static final int LEVEL_2_POINT = 192;
    private static final int LEVEL_3_POINT = 384;
    private static final int LEVEL_0_HEALTH = 20;
    private static final int LEVEL_1_HEALTH = 30;
    private static final int LEVEL_2_HEALTH = 40;
    private static final int LEVEL_3_HEALTH = 80;
    private static final int LEVEL_0_ATTACK_DAMAGE = 2;
    private static final int LEVEL_1_ATTACK_DAMAGE = 2;
    private static final int LEVEL_2_ATTACK_DAMAGE = 5;
    private static final int LEVEL_3_ATTACK_DAMAGE = 10;
    private static final String TAG_NAME = "FavorabilityManagerCounter";
    private final Map<String, Time> counter = Maps.newHashMap();
    private final EntityMaid maid;

    public FavorabilityManager(EntityMaid maid) {
        this.maid = maid;
    }

    public void tick() {
        this.counter.values().forEach(Time::tick);
    }

    public void apply(String type) {
        Type typeInstance = TYPES.get(type);
        if (typeInstance != null) {
            this.apply(typeInstance);
        }
    }

    public void apply(Type type) {
        if (this.canAdd(type.getTypeName())) {
            if (type.isReduce()) {
                this.reduce(type.getPoint());
            } else {
                this.add(type.getPoint());
            }
            this.addCooldown(type.getTypeName(), type.getCooldown());
        }
    }

    private void addCooldown(String type, int tickCount) {
        this.counter.put(type, new Time(tickCount));
    }

    private boolean canAdd(String type) {
        if (this.counter.containsKey(type)) {
            return this.counter.get(type).isZero();
        }
        return true;
    }

    public int getLevel() {
        return this.getLevel(this.maid.getFavorability());
    }

    private int getLevel(int favorability) {
        if (favorability < 64) {
            return 0;
        }
        if (favorability < 192) {
            return 1;
        }
        if (favorability < 384) {
            return 2;
        }
        return 3;
    }

    public double getLevelPercent() {
        int favorability = this.maid.getFavorability();
        if (favorability < 64) {
            return (double)favorability / 64.0;
        }
        if (favorability < 192) {
            return (double)(favorability - 64) / 128.0;
        }
        if (favorability < 384) {
            return (double)(favorability - 192) / 192.0;
        }
        return 0.0;
    }

    public int nextLevelPoint() {
        int level = this.getLevel();
        if (level == 3) {
            return 0;
        }
        int pointByLevel = this.getPointByLevel(level + 1);
        return pointByLevel - this.maid.getFavorability();
    }

    public int getHealthByLevel(int level) {
        switch (level) {
            case 1: {
                return 30;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 80;
            }
        }
        return 20;
    }

    public int getAttackByLevel(int level) {
        switch (level) {
            case 1: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 10;
            }
        }
        return 2;
    }

    public int getPointByLevel(int level) {
        switch (level) {
            case 1: {
                return 64;
            }
            case 2: {
                return 192;
            }
            case 3: {
                return 384;
            }
        }
        return 0;
    }

    public void add(int addPoint) {
        int favorability = this.maid.getFavorability();
        int levelBefore = this.getLevel();
        int result = MathHelper.func_76125_a((int)(favorability + addPoint), (int)0, (int)384);
        this.maid.setFavorability(result);
        int levelAfter = this.getLevel();
        if (levelBefore < levelAfter) {
            ModifiableAttributeInstance attack = this.maid.func_110148_a(Attributes.field_233823_f_);
            ModifiableAttributeInstance health = this.maid.func_110148_a(Attributes.field_233818_a_);
            if (attack != null) {
                attack.func_111128_a((double)this.getAttackByLevel(levelAfter));
            }
            if (health != null) {
                if (this.maid.isStruckByLightning()) {
                    health.func_111128_a((double)(this.getHealthByLevel(levelAfter) + 20));
                } else {
                    health.func_111128_a((double)this.getHealthByLevel(levelAfter));
                }
                if (this.maid.func_110143_aJ() > this.maid.func_110138_aP()) {
                    this.maid.func_70606_j(this.maid.func_110138_aP());
                }
            }
            this.maid.func_184185_a(SoundEvents.field_187802_ec, 0.5f, this.maid.func_70681_au().nextFloat() * 0.1f + 0.9f);
        }
        NetworkHandler.sendToNearby((Entity)this.maid, new SpawnParticleMessage(this.maid.func_145782_y(), SpawnParticleMessage.Type.HEART));
    }

    public void reduce(int reducePoint) {
        int favorability = this.maid.getFavorability();
        int pointByLevel = this.getPointByLevel(this.getLevel());
        int result = MathHelper.func_76125_a((int)(favorability - reducePoint), (int)pointByLevel, (int)384);
        this.maid.setFavorability(result);
    }

    public void reduceWithoutLevel(int reducePoint) {
        int favorability = this.maid.getFavorability();
        int levelBefore = this.getLevel();
        int result = MathHelper.func_76125_a((int)(favorability - reducePoint), (int)0, (int)384);
        this.maid.setFavorability(result);
        int levelAfter = this.getLevel();
        if (levelBefore > levelAfter) {
            ModifiableAttributeInstance attack = this.maid.func_110148_a(Attributes.field_233823_f_);
            ModifiableAttributeInstance health = this.maid.func_110148_a(Attributes.field_233818_a_);
            if (attack != null) {
                attack.func_111128_a((double)this.getAttackByLevel(levelAfter));
            }
            if (health != null) {
                if (this.maid.isStruckByLightning()) {
                    health.func_111128_a((double)(this.getHealthByLevel(levelAfter) + 20));
                } else {
                    health.func_111128_a((double)this.getHealthByLevel(levelAfter));
                }
                if (this.maid.func_110143_aJ() > this.maid.func_110138_aP()) {
                    this.maid.func_70606_j(this.maid.func_110138_aP());
                }
            }
        }
    }

    public void max() {
        this.add(384);
    }

    public void addAdditionalSaveData(CompoundNBT compound) {
        CompoundNBT data = new CompoundNBT();
        this.counter.forEach((name, time) -> data.func_74768_a(name, time.getTickCount()));
        compound.func_218657_a(TAG_NAME, (INBT)data);
    }

    public void readAdditionalSaveData(CompoundNBT compound) {
        if (compound.func_150297_b(TAG_NAME, 10)) {
            CompoundNBT data = compound.func_74775_l(TAG_NAME);
            for (String name : data.func_150296_c()) {
                this.counter.put(name, new Time(data.func_74762_e(name)));
            }
        }
    }

    public static class Time {
        private int tickCount;

        public Time(int tickCount) {
            this.tickCount = tickCount;
        }

        public int getTickCount() {
            return this.tickCount;
        }

        public void setTickCount(int tickCount) {
            this.tickCount = tickCount;
        }

        public void tick() {
            if (this.tickCount > 0) {
                --this.tickCount;
            }
        }

        public boolean isZero() {
            return this.tickCount <= 0;
        }
    }
}

