/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class AbstractEntityFromItem
extends LivingEntity {
    public AbstractEntityFromItem(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected abstract boolean canKillEntity(PlayerEntity var1);

    protected abstract SoundEvent getHitSound();

    protected abstract Item getWithItem();

    protected abstract ItemStack getKilledStack();

    public void func_174812_G() {
        this.func_70106_y();
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70729_aU && this.func_70089_S()) {
            if (this.func_180431_b(source)) {
                return false;
            }
            if (source.func_76364_f() instanceof PlayerEntity) {
                return this.applyHitEntityLogic((PlayerEntity)source.func_76364_f());
            }
        }
        return false;
    }

    private boolean applyHitEntityLogic(PlayerEntity player) {
        if (player.func_225608_bj_()) {
            this.func_184226_ay();
            this.func_184185_a(this.getHitSound(), 1.0f, 1.0f);
            if (player.func_184812_l_() && !this.func_145818_k_()) {
                this.func_70106_y();
            } else if (this.canKillEntity(player)) {
                this.killEntity();
            }
            LazyOptional itemHandler = this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (!this.field_70170_p.field_72995_K) {
                itemHandler.ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack itemstack = handler.getStackInSlot(i);
                        InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)itemstack);
                    }
                });
            }
        }
        return true;
    }

    private void killEntity() {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack itemstack = this.getKilledStack();
            if (this.func_145818_k_()) {
                itemstack.func_200302_a(this.func_200201_e());
            }
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return this.getKilledStack();
    }

    public boolean func_190631_cK() {
        return false;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.LEFT;
    }
}

