/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityBox
extends Entity {
    public static final int FIRST_STAGE = 64;
    public static final int SECOND_STAGE = 60;
    public static final int THIRD_STAGE = 0;
    public static final int MAX_TEXTURE_SIZE = 7;
    private static final DataParameter<Integer> OPEN_STAGE = EntityDataManager.func_187226_a(EntityBox.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TEXTURE_INDEX = EntityDataManager.func_187226_a(EntityBox.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final EntityType<EntityBox> TYPE = EntityType.Builder.func_220322_a(EntityBox::new, (EntityClassification)EntityClassification.MISC).func_220321_a(2.0f, 2.0f).func_233606_a_(10).func_206830_a("box");
    private static final String STAGE_TAG = "OpenStage";
    private static final String TEXTURE_TAG = "TextureIndex";

    public EntityBox(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.setRandomTexture();
    }

    public EntityBox(World worldIn) {
        this(TYPE, worldIn);
    }

    public void func_70030_z() {
        if (!this.func_189652_ae() && !this.field_70122_E) {
            this.func_213315_a(MoverType.SELF, this.func_213322_ci().func_72441_c(0.0, -0.1, 0.0));
        }
        super.func_70030_z();
        int stage = this.getOpenStage();
        this.stageChange(stage);
        this.func_184188_bt().stream().filter(e -> e instanceof TameableEntity).forEach(e -> this.applyInvisibilityEffect((TameableEntity)e, stage));
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.getOpenStage() == 64) {
            this.setOpenStage(63);
            this.func_184185_a((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 1.0f);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (this.getOpenStage() == 60) {
            this.setOpenStage(59);
            this.func_184185_a((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 1.0f);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (this.getOpenStage() == 0) {
            this.setOpenStage(-1);
            this.func_184185_a((SoundEvent)InitSounds.BOX_OPEN.get(), 3.0f, 2.0f);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_184230_a(player, hand);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OPEN_STAGE, (Object)64);
        this.field_70180_af.func_187214_a(TEXTURE_INDEX, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b(STAGE_TAG)) {
            this.setOpenStage(compound.func_74762_e(STAGE_TAG));
        }
        if (compound.func_74764_b(TEXTURE_TAG)) {
            this.setTextureIndex(compound.func_74762_e(TEXTURE_TAG));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a(STAGE_TAG, this.getOpenStage());
        compound.func_74768_a(TEXTURE_TAG, this.getTextureIndex());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean func_241845_aY() {
        return this.func_70089_S();
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public int getOpenStage() {
        return (Integer)this.field_70180_af.func_187225_a(OPEN_STAGE);
    }

    public void setOpenStage(int stage) {
        this.field_70180_af.func_187227_b(OPEN_STAGE, (Object)MathHelper.func_76125_a((int)stage, (int)-1, (int)64));
    }

    public int getTextureIndex() {
        return (Integer)this.field_70180_af.func_187225_a(TEXTURE_INDEX);
    }

    public void setTextureIndex(int index) {
        this.field_70180_af.func_187227_b(TEXTURE_INDEX, (Object)MathHelper.func_76125_a((int)index, (int)1, (int)6));
    }

    public void setRandomTexture() {
        this.setTextureIndex(this.field_70146_Z.nextInt(7));
    }

    private void stageChange(int stage) {
        if (stage != 64 && stage != 60 && stage != 0) {
            this.setOpenStage(stage - 1);
        }
        if (stage < 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.func_199702_a((IItemProvider)Items.field_151121_aF, 2 + this.field_70146_Z.nextInt(3));
            }
        }
    }

    private void applyInvisibilityEffect(TameableEntity tameable, int stage) {
        if (stage >= 64) {
            tameable.func_195064_c(new EffectInstance(Effects.field_76441_p, 2, 1, false, false));
        }
    }
}

