/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.ChairConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemChair;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenChairGuiMessage;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class EntityChair
extends AbstractEntityFromItem {
    public static final EntityType<EntityChair> TYPE = EntityType.Builder.func_220322_a(EntityChair::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.875f, 0.5f).func_233606_a_(10).func_206830_a("chair");
    private static final DataParameter<String> MODEL_ID = EntityDataManager.func_187226_a(EntityChair.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> MOUNTED_HEIGHT = EntityDataManager.func_187226_a(EntityChair.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> TAMEABLE_CAN_RIDE = EntityDataManager.func_187226_a(EntityChair.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(EntityChair.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final String MODEL_ID_TAG = "ModelId";
    private static final String MOUNTED_HEIGHT_TAG = "MountedHeight";
    private static final String TAMEABLE_CAN_RIDE_TAG = "TameableCanRide";
    private static final String OWNER_UUID_TAG = "OwnerUUID";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:cushion";

    protected EntityChair(EntityType<EntityChair> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityChair(World worldIn) {
        this(TYPE, worldIn);
    }

    public EntityChair(World worldIn, double x, double y, double z, float yaw) {
        this(TYPE, worldIn);
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, 0.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MODEL_ID, (Object)DEFAULT_MODEL_ID);
        this.field_70180_af.func_187214_a(MOUNTED_HEIGHT, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TAMEABLE_CAN_RIDE, (Object)true);
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
    }

    protected void func_85033_bc() {
        if (!this.isTameableCanRide()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_175647_a(TameableEntity.class, this.func_174813_aQ().func_72321_a(0.0, 0.5, 0.0), e -> !e.func_233684_eK_() && !e.func_184218_aH() && e.func_184188_bt().isEmpty());
            list.stream().findFirst().ifPresent(entity -> entity.func_184220_m((Entity)this));
        }
    }

    public void func_70108_f(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !EffectiveSide.get().isServer();
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_225608_bj_()) {
            if (player.func_184586_b(hand).func_111282_a_(player, (LivingEntity)this, hand).func_226246_a_()) {
                return ActionResultType.SUCCESS;
            }
            if (!this.field_70170_p.field_72995_K) {
                NetworkHandler.sendToClientPlayer(new OpenChairGuiMessage(this.func_145782_y()), player);
            }
        } else if (!this.field_70170_p.field_72995_K && this.func_184188_bt().isEmpty() && !player.func_184218_aH()) {
            player.func_184220_m((Entity)this);
        }
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        BedrockModel model = CustomPackLoader.CHAIR_MODELS.getModel(this.getModelId()).orElse(null);
        if (model == null) {
            return super.func_184177_bl();
        }
        return model.getRenderBoundingBox().func_191194_a(this.func_213303_ch());
    }

    public double func_70042_X() {
        return this.getMountedHeight();
    }

    @Override
    protected boolean canKillEntity(PlayerEntity player) {
        if (((Boolean)ChairConfig.CHAIR_CAN_DESTROYED_BY_ANYONE.get()).booleanValue()) {
            return true;
        }
        return this.getOwnerUUID().map(uuid -> player.func_110124_au().equals(uuid)).orElse(true);
    }

    @Override
    protected SoundEvent getHitSound() {
        return SoundEvents.field_187546_ae;
    }

    @Override
    protected Item getWithItem() {
        return (Item)InitItems.CHAIR.get();
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(MODEL_ID_TAG, 8)) {
            this.setModelId(compound.func_74779_i(MODEL_ID_TAG));
        }
        if (compound.func_150297_b(MOUNTED_HEIGHT_TAG, 5)) {
            this.setMountedHeight(compound.func_74760_g(MOUNTED_HEIGHT_TAG));
        }
        if (compound.func_150297_b(TAMEABLE_CAN_RIDE_TAG, 1)) {
            this.setTameableCanRide(compound.func_74767_n(TAMEABLE_CAN_RIDE_TAG));
        }
        if (compound.func_74764_b(OWNER_UUID_TAG)) {
            this.setOwnerUUID(NBTUtil.func_186860_b((INBT)Objects.requireNonNull(compound.func_74781_a(OWNER_UUID_TAG))));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a(MODEL_ID_TAG, this.getModelId());
        compound.func_74776_a(MOUNTED_HEIGHT_TAG, this.getMountedHeight());
        compound.func_74757_a(TAMEABLE_CAN_RIDE_TAG, this.isTameableCanRide());
        this.getOwnerUUID().ifPresent(uuid -> compound.func_186854_a(OWNER_UUID_TAG, uuid));
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public String getModelId() {
        return (String)this.field_70180_af.func_187225_a(MODEL_ID);
    }

    public void setModelId(String modelId) {
        this.field_70180_af.func_187227_b(MODEL_ID, (Object)modelId);
    }

    public float getMountedHeight() {
        return ((Float)this.field_70180_af.func_187225_a(MOUNTED_HEIGHT)).floatValue();
    }

    public void setMountedHeight(float height) {
        height = MathHelper.func_76131_a((float)height, (float)-0.5f, (float)2.5f);
        this.field_70180_af.func_187227_b(MOUNTED_HEIGHT, (Object)Float.valueOf(height));
    }

    public boolean isTameableCanRide() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMEABLE_CAN_RIDE);
    }

    public void setTameableCanRide(boolean canRide) {
        this.field_70180_af.func_187227_b(TAMEABLE_CAN_RIDE, (Object)canRide);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.field_70180_af.func_187225_a(OWNER_UUID);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(@Nullable PlayerEntity player) {
        if (player != null) {
            this.setOwnerUUID(player.func_110124_au());
        }
    }

    public boolean hasPassenger() {
        return !this.func_184188_bt().isEmpty();
    }

    public float getPassengerYaw() {
        if (!this.func_184188_bt().isEmpty()) {
            return ((Entity)this.func_184188_bt().get((int)0)).field_70177_z;
        }
        return 0.0f;
    }

    public float getYaw() {
        return this.field_70177_z;
    }

    public float getPassengerPitch() {
        if (!this.func_184188_bt().isEmpty()) {
            return ((Entity)this.func_184188_bt().get((int)0)).field_70125_A;
        }
        return 0.0f;
    }

    @Deprecated
    public int getDim() {
        RegistryKey dim = this.field_70170_p.func_234923_W_();
        if (dim.equals(World.field_234918_g_)) {
            return 0;
        }
        if (dim.equals(World.field_234919_h_)) {
            return -1;
        }
        if (dim.equals(World.field_234920_i_)) {
            return 1;
        }
        return 0;
    }

    @Override
    protected ItemStack getKilledStack() {
        return ItemChair.setData(((Item)InitItems.CHAIR.get()).func_190903_i(), new ItemChair.Data(this.getModelId(), this.getMountedHeight(), this.isTameableCanRide(), this.func_189652_ae()));
    }
}

