/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityExtinguishingAgent
extends Entity {
    public static final EntityType<EntityExtinguishingAgent> TYPE = EntityType.Builder.func_220322_a(EntityExtinguishingAgent::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.2f, 0.2f).func_233606_a_(10).func_206830_a("extinguishing_agent");
    private static final int MAX_AGE = 60;
    private static final int REMOVE_FIRE_AGE = 5;
    private List<MonsterEntity> cacheFireImmuneMonster = Lists.newArrayList();

    public EntityExtinguishingAgent(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityExtinguishingAgent(World worldIn, Vector3d position) {
        this(TYPE, worldIn);
        this.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70173_aa > 60) {
            this.func_70106_y();
            return;
        }
        if (this.field_70173_aa == 5) {
            this.removeBlockFire();
            this.removeEntityFire();
        }
        this.damageFireImmuneMonster();
        if (this.field_70170_p.field_72995_K) {
            this.spawnCloudParticle();
        }
        this.func_184185_a(SoundEvents.field_187552_ah, 2.0f - 0.03f * (float)this.field_70173_aa, 0.1f);
    }

    private void damageFireImmuneMonster() {
        if (this.field_70173_aa % 5 == 0 && this.cacheFireImmuneMonster != null && !this.cacheFireImmuneMonster.isEmpty()) {
            this.cacheFireImmuneMonster.forEach(monster -> {
                if (monster.func_70089_S()) {
                    monster.func_70097_a(DamageSource.field_76376_m, 2.0f);
                }
            });
        }
    }

    private void spawnCloudParticle() {
        int spawnNumber = 4;
        for (int i = 0; i < spawnNumber; ++i) {
            double offsetX = 2.0 * this.field_70146_Z.nextDouble() - 1.0;
            double offsetY = this.field_70146_Z.nextDouble() / 2.0;
            double offsetZ = 2.0 * this.field_70146_Z.nextDouble() - 1.0;
            this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197613_f, false, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ, 0.0, 0.1, 0.0);
        }
    }

    private void removeEntityFire() {
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0));
        this.cacheFireImmuneMonster = this.field_70170_p.func_175647_a(MonsterEntity.class, this.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0), Entity::func_230279_az_);
        for (LivingEntity entity : list) {
            entity.func_70066_B();
        }
    }

    private void removeBlockFire() {
        int hRange = 2;
        int vRange = 1;
        for (int x = -hRange; x <= hRange; ++x) {
            for (int y = -vRange; y <= vRange; ++y) {
                for (int z = -hRange; z <= hRange; ++z) {
                    BlockPos pos = this.func_233580_cy_().func_177982_a(x, y, z);
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    if (!state.func_203425_a(Blocks.field_150480_ab)) continue;
                    this.field_70170_p.func_217377_a(pos, false);
                }
            }
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

