/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.capability.PowerCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.BeaconAbsorbMessage;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SCollectItemPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityPowerPoint
extends Entity
implements IEntityAdditionalSpawnData {
    public static final EntityType<EntityPowerPoint> TYPE = EntityType.Builder.func_220322_a(EntityPowerPoint::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).func_233606_a_(6).func_233608_b_(20).func_206830_a("power_point");
    private static final int MAX_AGE = 6000;
    public int field_70173_aa;
    public int age;
    public int throwTime;
    public int value;
    private int health = 5;
    private PlayerEntity followingPlayer;
    private int followingTime;

    public EntityPowerPoint(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityPowerPoint(World worldIn, double x, double y, double z, int powerValue) {
        this(TYPE, worldIn);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(this.field_70146_Z.nextDouble() * 360.0);
        this.func_213293_j((this.field_70146_Z.nextDouble() * 0.2 - 0.1) * 2.0, this.field_70146_Z.nextDouble() * 0.2 * 2.0, (this.field_70146_Z.nextDouble() * 0.2 - 0.1) * 2.0);
        this.value = powerValue;
    }

    public static int getPowerValue(int powerValue) {
        if (powerValue >= 485) {
            return 485;
        }
        if (powerValue >= 385) {
            return 385;
        }
        if (powerValue >= 285) {
            return 285;
        }
        if (powerValue >= 185) {
            return 185;
        }
        if (powerValue >= 89) {
            return 89;
        }
        if (powerValue >= 36) {
            return 34;
        }
        if (powerValue >= 17) {
            return 13;
        }
        if (powerValue >= 7) {
            return 7;
        }
        if (powerValue >= 5) {
            return 5;
        }
        return powerValue >= 3 ? 3 : 1;
    }

    public static int transPowerValueToXpValue(int powerValue) {
        return powerValue / 4;
    }

    public static void spawnExplosionParticle(World world, float x, float y, float z, Random rand) {
        if (!world.field_72995_K) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            float mx = (rand.nextFloat() - 0.5f) * 0.02f;
            float my = (rand.nextFloat() - 0.5f) * 0.02f;
            float mz = (rand.nextFloat() - 0.5f) * 0.02f;
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, (double)(x + rand.nextFloat() - 0.5f), (double)(y + rand.nextFloat() - 0.5f), (double)(z + rand.nextFloat() - 0.5f), (double)mx, (double)my, (double)mz);
        }
    }

    public void spawnExplosionParticle() {
        float x = (float)this.func_213303_ch().field_72450_a;
        float y = (float)this.func_213303_ch().field_72448_b + 0.125f;
        float z = (float)this.func_213303_ch().field_72449_c;
        if (this.field_70170_p.field_72995_K) {
            EntityPowerPoint.spawnExplosionParticle(this.field_70170_p, x, y, z, this.field_70146_Z);
        } else {
            NetworkHandler.sendToNearby(this.field_70170_p, this.func_233580_cy_(), new BeaconAbsorbMessage(x, y, z));
        }
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.throwTime > 0) {
            --this.throwTime;
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        this.fluidMovement();
        if (!this.field_70170_p.func_226664_a_(this.func_174813_aQ())) {
            this.func_213282_i(this.func_226277_ct_(), (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.func_226281_cx_());
        }
        this.followingMovement();
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.groundMovement();
        ++this.field_70173_aa;
        ++this.age;
        if (this.age >= 6000) {
            this.func_70106_y();
        }
    }

    private void groundMovement() {
        double slipperiness = 0.98;
        if (this.field_70122_E) {
            BlockPos pos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
            slipperiness = (double)this.field_70170_p.func_180495_p(pos).getSlipperiness((IWorldReader)this.field_70170_p, pos, (Entity)this) * 0.98;
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d(slipperiness, 0.98, slipperiness));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, -0.9, 1.0));
        }
    }

    private void followingMovement() {
        Vector3d relativeVector;
        double length;
        double distance = 8.0;
        if (this.followingTime < this.getRandomCheckTime()) {
            if (this.followingPlayer == null || (double)this.followingPlayer.func_70032_d((Entity)this) > distance) {
                this.followingPlayer = this.field_70170_p.func_217362_a((Entity)this, distance);
            }
            this.followingTime = this.field_70173_aa;
        }
        if (this.followingPlayer != null && this.followingPlayer.func_175149_v()) {
            this.followingPlayer = null;
        }
        if (this.followingPlayer != null && (length = (relativeVector = new Vector3d(this.followingPlayer.func_226277_ct_() - this.func_226277_ct_(), this.followingPlayer.func_226278_cu_() + (double)this.followingPlayer.func_70047_e() / 2.0 - this.func_226278_cu_(), this.followingPlayer.func_226281_cx_() - this.func_226281_cx_())).func_72433_c()) < distance) {
            double factor = 1.0 - length / 8.0;
            this.func_213317_d(this.func_213322_ci().func_178787_e(relativeVector.func_72432_b().func_186678_a(factor * factor * 0.1)));
        }
    }

    private int getRandomCheckTime() {
        return this.field_70173_aa - 20 + this.func_145782_y() % 100;
    }

    private void fluidMovement() {
        if (this.func_208600_a((ITag)FluidTags.field_206959_a)) {
            Vector3d movement = this.func_213322_ci();
            this.func_213293_j(movement.field_72450_a * 0.99, Math.min(movement.field_72448_b + 5.0E-4, 0.06), movement.field_72449_c * 0.99);
        } else if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
        }
        if (this.field_70170_p.func_204610_c(this.func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b)) {
            this.func_213293_j((this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.2, 0.2, (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.2);
            this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
    }

    protected void func_71061_d_() {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || !this.func_70089_S()) {
            return false;
        }
        if (!this.func_180431_b(source)) {
            this.func_70018_K();
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                this.func_70106_y();
            }
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74777_a("Health", (short)this.health);
        compound.func_74777_a("Age", (short)this.age);
        compound.func_74777_a("Value", (short)this.value);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.health = compound.func_74765_d("Health");
        this.age = compound.func_74765_d("Age");
        this.value = compound.func_74765_d("Value");
    }

    public void func_70100_b_(PlayerEntity player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.throwTime == 0 && player.field_71090_bL == 0) {
            LazyOptional powerCap = player.getCapability(PowerCapabilityProvider.POWER_CAP, null);
            powerCap.ifPresent(power -> {
                player.field_71090_bL = 2;
                this.take((Entity)player, 1);
                if (this.value > 0) {
                    if (power.get() + (float)this.value / 100.0f > 5.0f) {
                        power.add(5.0f - power.get());
                        int residualValue = this.value - 500 + (int)(power.get() * 100.0f);
                        player.func_195068_e(EntityPowerPoint.transPowerValueToXpValue(residualValue));
                    } else {
                        power.add((float)this.value / 100.0f);
                    }
                }
                this.func_70106_y();
            });
        }
    }

    public void take(Entity player, int quantity) {
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K) {
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b((Entity)this, (IPacket)new SCollectItemPacket(this.func_145782_y(), player.func_145782_y(), quantity));
        }
    }

    public int getValue() {
        return this.value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIcon() {
        if (this.value >= 485) {
            return 10;
        }
        if (this.value >= 385) {
            return 9;
        }
        if (this.value >= 285) {
            return 8;
        }
        if (this.value >= 185) {
            return 7;
        }
        if (this.value >= 89) {
            return 6;
        }
        if (this.value >= 36) {
            return 5;
        }
        if (this.value >= 17) {
            return 4;
        }
        if (this.value >= 7) {
            return 3;
        }
        if (this.value >= 5) {
            return 2;
        }
        return this.value >= 3 ? 1 : 0;
    }

    public boolean func_70075_an() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.value);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.value = additionalData.readInt();
    }
}

