/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskBoardGames;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.StringUtils;

public class EntitySit
extends Entity {
    public static final EntityType<EntitySit> TYPE = EntityType.Builder.func_220322_a(EntitySit::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.1f).func_233606_a_(10).func_206830_a("sit");
    private static final DataParameter<String> SIT_TYPE = EntityDataManager.func_187226_a(EntitySit.class, (IDataSerializer)DataSerializers.field_187194_d);
    private int passengerTick = 0;

    public EntitySit(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntitySit(World worldIn, Vector3d pos, String joyType) {
        this(TYPE, worldIn);
        this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        this.setJoyType(joyType);
    }

    public double func_70042_X() {
        return -0.25;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SIT_TYPE, (Object)"");
    }

    protected void func_70037_a(CompoundNBT tag) {
        if (tag.func_150297_b("SitJoyType", 8)) {
            this.setJoyType(tag.func_74779_i("SitJoyType"));
        }
    }

    protected void func_213281_b(CompoundNBT tag) {
        if (StringUtils.isNotBlank((CharSequence)this.getJoyType())) {
            tag.func_74778_a("SitJoyType", this.getJoyType());
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.checkBelowWorld();
            this.checkPassengers();
            if (this.getFirstPassenger() instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)this.getFirstPassenger();
                this.tickMaid(maid);
            }
        }
    }

    private void checkBelowWorld() {
        if (this.func_226278_cu_() < -64.0) {
            this.func_70076_C();
        }
    }

    @Nullable
    public Entity getFirstPassenger() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    private void tickMaid(EntityMaid maid) {
        maid.field_70177_z = this.field_70177_z;
        maid.func_70034_d(this.field_70177_z);
        if (this.field_70173_aa % 20 == 0) {
            FavorabilityManager manager = maid.getFavorabilityManager();
            manager.apply(this.getJoyType());
            if (!this.isIdleSchedule(maid) && !this.isGomokuTask(maid)) {
                maid.func_184210_p();
            }
        }
    }

    private void checkPassengers() {
        this.passengerTick = this.func_184188_bt().isEmpty() ? ++this.passengerTick : 0;
        if (this.passengerTick > 10) {
            this.func_70106_y();
        }
    }

    private boolean isGomokuTask(EntityMaid maid) {
        return Type.GOMOKU.getTypeName().equals(this.getJoyType()) && maid.getTask().getUid().equals((Object)TaskBoardGames.UID) && this.isWorkSchedule(maid);
    }

    private boolean isIdleSchedule(EntityMaid maid) {
        return maid.getScheduleDetail() == Activity.field_221366_b;
    }

    private boolean isWorkSchedule(EntityMaid maid) {
        return maid.getScheduleDetail() == Activity.field_221367_c;
    }

    public boolean func_85031_j(Entity pEntity) {
        return true;
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        return false;
    }

    public void func_213315_a(MoverType pType, Vector3d pPos) {
    }

    public void func_70108_f(Entity entity) {
    }

    public void func_70024_g(double pX, double pY, double pZ) {
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void func_241841_a(ServerWorld pLevel, LightningBoltEntity pLightning) {
    }

    public void func_213323_x_() {
    }

    public boolean func_241849_j(Entity entity) {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public String getJoyType() {
        return (String)this.field_70180_af.func_187225_a(SIT_TYPE);
    }

    public void setJoyType(String type) {
        this.field_70180_af.func_187227_b(SIT_TYPE, (Object)type);
    }
}

