/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class EntityTombstone
extends Entity {
    public static final EntityType<EntityTombstone> TYPE = EntityType.Builder.func_220322_a(EntityTombstone::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.8f, 1.2f).func_233606_a_(10).func_206830_a("tombstone");
    private static final String OWNER_ID_TAG = "OwnerId";
    private static final String TOMBSTONE_ITEMS_TAG = "TombstoneItems";
    private static final String MAID_NAME_TAG = "MaidName";
    private static final DataParameter<ITextComponent> MAID_NAME = EntityDataManager.func_187226_a(EntityTombstone.class, (IDataSerializer)DataSerializers.field_187195_e);
    private final ItemStackHandler items = new ItemStackHandler(64);
    private UUID ownerId = Util.field_240973_b_;

    public EntityTombstone(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityTombstone(World worldIn, UUID ownerId, Vector3d pos) {
        this(TYPE, worldIn);
        this.ownerId = ownerId;
        this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public void insertItem(ItemStack item) {
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.items, (ItemStack)item, (boolean)false);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_110124_au().equals(this.ownerId)) {
            for (int i = 0; i < this.items.getSlots(); ++i) {
                int size = this.items.getSlotLimit(i);
                ItemStack extractItem = this.items.extractItem(i, size, false);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)extractItem);
            }
            this.removeFromData();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_184230_a(player, hand);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(MAID_NAME, (Object)StringTextComponent.field_240750_d_);
    }

    protected void func_70037_a(CompoundNBT tag) {
        if (tag.func_74764_b(OWNER_ID_TAG)) {
            this.ownerId = tag.func_186857_a(OWNER_ID_TAG);
        }
        if (tag.func_74764_b(TOMBSTONE_ITEMS_TAG)) {
            this.items.deserializeNBT(tag.func_74775_l(TOMBSTONE_ITEMS_TAG));
        }
        if (tag.func_74764_b(MAID_NAME_TAG)) {
            String nameJson = tag.func_74779_i(MAID_NAME_TAG);
            this.setMaidName((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)nameJson));
        }
    }

    protected void func_213281_b(CompoundNBT tag) {
        tag.func_186854_a(OWNER_ID_TAG, this.ownerId);
        tag.func_218657_a(TOMBSTONE_ITEMS_TAG, (INBT)this.items.serializeNBT());
        tag.func_74778_a(MAID_NAME_TAG, ITextComponent.Serializer.func_150696_a((ITextComponent)this.getMaidName()));
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.checkBelowWorld();
        }
    }

    private void checkBelowWorld() {
        if (this.func_226278_cu_() < -64.0) {
            this.func_70076_C();
        }
    }

    public boolean func_85031_j(Entity pEntity) {
        return true;
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        return false;
    }

    public void func_213315_a(MoverType pType, Vector3d pPos) {
    }

    public void func_70108_f(Entity entity) {
    }

    public void func_70024_g(double pX, double pY, double pZ) {
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void func_241841_a(ServerWorld pLevel, LightningBoltEntity pLightning) {
    }

    public void func_213323_x_() {
    }

    private void removeFromData() {
        MaidWorldData maidWorldData = MaidWorldData.get(this.field_70170_p);
        if (maidWorldData != null) {
            maidWorldData.removeTombstones(this);
        }
        this.func_70106_y();
    }

    public boolean func_241849_j(Entity entity) {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public ITextComponent getMaidName() {
        return (ITextComponent)this.field_70180_af.func_187225_a(MAID_NAME);
    }

    public void setMaidName(@Nullable ITextComponent name) {
        if (name != null) {
            this.field_70180_af.func_187227_b(MAID_NAME, (Object)name);
        }
    }
}

