/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.monster;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.goal.FairyAttackGoal;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.FairyType;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.IHasPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuShoot;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class EntityFairy
extends MonsterEntity
implements IRangedAttackMob,
IFlyingAnimal,
IHasPowerPoint {
    public static final EntityType<EntityFairy> TYPE = EntityType.Builder.func_220322_a(EntityFairy::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.5f).func_233606_a_(10).func_206830_a("fairy");
    private static final String FAIRY_TYPE_TAG_NAME = "FairyType";
    private static final DataParameter<Integer> FAIRY_TYPE = EntityDataManager.func_187226_a(EntityFairy.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final double AIMED_SHOT_PROBABILITY = 0.9;

    protected EntityFairy(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 15, true);
    }

    public EntityFairy(World worldIn) {
        this(TYPE, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute createFairyAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 1.5).func_233815_a_(Attributes.field_233826_i_, 1.0).func_233815_a_(Attributes.field_233822_e_, 0.4);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FairyAttackGoal(this, 6.0, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, EntityMaid.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FAIRY_TYPE, (Object)FairyType.BLACK.ordinal());
    }

    @Override
    public int getPowerPoint() {
        return (int)((Double)MiscConfig.MAID_FAIRY_POWER_POINT.get() * 100.0);
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        this.dropPowerPoint((LivingEntity)this);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if ((double)this.field_70146_Z.nextFloat() <= 0.9) {
            DanmakuShoot.create().setWorld(this.field_70170_p).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + 1.0f).setGravity(0.0f).setVelocity(0.2f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).aimedShot();
        } else {
            DanmakuShoot.create().setWorld(this.field_70170_p).setThrower((LivingEntity)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + 1.5f).setGravity(0.0f).setVelocity(0.2f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(3).setYawTotal(0.5235987755982988).fanShapedShot();
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator navigator = new FlyingPathNavigator((MobEntity)this, worldIn);
        navigator.func_192879_a(false);
        navigator.func_212239_d(true);
        navigator.func_192878_b(true);
        return navigator;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setFairyTypeOrdinal(this.field_70146_Z.nextInt(FairyType.values().length));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a(FAIRY_TYPE_TAG_NAME, this.getFairyTypeOrdinal());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(FAIRY_TYPE_TAG_NAME, 3)) {
            this.setFairyTypeOrdinal(compound.func_74762_e(FAIRY_TYPE_TAG_NAME));
        }
    }

    public int getFairyTypeOrdinal() {
        return (Integer)this.field_70180_af.func_187225_a(FAIRY_TYPE);
    }

    public void setFairyTypeOrdinal(int ordinal) {
        this.field_70180_af.func_187227_b(FAIRY_TYPE, (Object)ordinal);
    }
}

