/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAttackEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDeathEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidHurtEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidPlaySoundEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTickEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.client.model.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeCompat;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidBrain;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BigBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.EmptyBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.MiddleBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.SmallBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.MaidChatBubbles;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.MaidScriptBookManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.info.ServerCustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.DefaultMaidSoundPack;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskIdle;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.MaidBackpackHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.MaidHandsInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFilm;
import com.github.tartaricacid.touhoulittlemaid.mixin.MixinArrowEntity;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.ItemBreakMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.PlayMaidSoundMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectMessage;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.TeleportHelper;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ObjectUtils;

public class EntityMaid
extends TameableEntity
implements ICrossbowUser {
    public static final EntityType<EntityMaid> TYPE = EntityType.Builder.func_220322_a(EntityMaid::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.5f).func_233606_a_(10).func_206830_a("maid");
    public static final String MODEL_ID_TAG = "ModelId";
    public static final String SOUND_PACK_ID_TAG = "SoundPackId";
    public static final String MAID_BACKPACK_TYPE = "MaidBackpackType";
    public static final String MAID_INVENTORY_TAG = "MaidInventory";
    public static final String MAID_BAUBLE_INVENTORY_TAG = "MaidBaubleInventory";
    public static final String EXPERIENCE_TAG = "MaidExperience";
    private static final DataParameter<String> DATA_MODEL_ID = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DATA_SOUND_PACK_ID = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DATA_TASK = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> DATA_BEGGING = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_PICKUP = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_HOME_MODE = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_RIDEABLE = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_INVULNERABLE = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DATA_HUNGER = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_FAVORABILITY = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_EXPERIENCE = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_STRUCK_BY_LIGHTNING = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_IS_CHARGING_CROSSBOW = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_ARM_RISE = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<MaidSchedule> SCHEDULE_MODE = EntityDataManager.func_187226_a(EntityMaid.class, MaidSchedule.DATA);
    private static final DataParameter<BlockPos> RESTRICT_CENTER = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Float> RESTRICT_RADIUS = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<MaidChatBubbles> CHAT_BUBBLE = EntityDataManager.func_187226_a(EntityMaid.class, MaidChatBubbles.DATA);
    private static final DataParameter<String> BACKPACK_TYPE = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<ItemStack> BACKPACK_ITEM_SHOW = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<String> BACKPACK_FLUID = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<CompoundNBT> GAME_SKILL = EntityDataManager.func_187226_a(EntityMaid.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final String TASK_TAG = "MaidTask";
    private static final String PICKUP_TAG = "MaidIsPickup";
    private static final String HOME_TAG = "MaidIsHome";
    private static final String RIDEABLE_TAG = "MaidIsRideable";
    private static final String STRUCK_BY_LIGHTNING_TAG = "StruckByLightning";
    private static final String INVULNERABLE_TAG = "Invulnerable";
    private static final String HUNGER_TAG = "MaidHunger";
    private static final String FAVORABILITY_TAG = "MaidFavorability";
    private static final String SCHEDULE_MODE_TAG = "MaidScheduleMode";
    private static final String BACKPACK_DATA_TAG = "MaidBackpackData";
    private static final String GAME_SKILL_TAG = "MaidGameSkillData";
    @Deprecated
    private static final String BACKPACK_LEVEL_TAG = "MaidBackpackLevel";
    @Deprecated
    private static final String RESTRICT_CENTER_TAG = "MaidRestrictCenter";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private final EntityArmorInvWrapper armorInvWrapper = new EntityArmorInvWrapper((LivingEntity)this);
    private final EntityHandsInvWrapper handsInvWrapper = new MaidHandsInvWrapper((LivingEntity)this);
    private final ItemStackHandler maidInv = new MaidBackpackHandler(36, this);
    private final BaubleItemHandler maidBauble = new BaubleItemHandler(9);
    private final FavorabilityManager favorabilityManager;
    private final MaidScriptBookManager scriptBookManager;
    private final SchedulePos schedulePos;
    public boolean guiOpening = false;
    private List<SendEffectMessage.EffectData> effects = Lists.newArrayList();
    private IMaidTask task = TaskManager.getIdleTask();
    private IMaidBackpack backpack = BackpackManager.getEmptyBackpack();
    private int playerHurtSoundCount = 120;
    private int pickupSoundCount = 5;
    private int backpackDelay = 0;
    private IBackpackData backpackData = null;

    protected EntityMaid(EntityType<EntityMaid> type, World world) {
        super(type, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.favorabilityManager = new FavorabilityManager(this);
        this.scriptBookManager = new MaidScriptBookManager();
        this.schedulePos = new SchedulePos(BlockPos.field_177992_a, world.func_234923_W_().func_240901_a_());
    }

    public EntityMaid(World worldIn) {
        this(TYPE, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233819_b_, 64.0).func_233814_a_(Attributes.field_233824_g_).func_233814_a_(Attributes.field_233823_f_);
    }

    public static boolean canInsertItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof BlockItem) {
            Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
            return !(block instanceof ShulkerBoxBlock);
        }
        return stack.func_77973_b() != InitItems.SMART_SLAB_HAS_MAID.get() && stack.func_77973_b() != InitItems.PHOTO.get();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_MODEL_ID, (Object)DEFAULT_MODEL_ID);
        this.field_70180_af.func_187214_a(DATA_SOUND_PACK_ID, (Object)DefaultMaidSoundPack.getInitSoundPackId());
        this.field_70180_af.func_187214_a(DATA_TASK, (Object)TaskIdle.UID.toString());
        this.field_70180_af.func_187214_a(DATA_BEGGING, (Object)false);
        this.field_70180_af.func_187214_a(DATA_PICKUP, (Object)true);
        this.field_70180_af.func_187214_a(DATA_HOME_MODE, (Object)false);
        this.field_70180_af.func_187214_a(DATA_RIDEABLE, (Object)true);
        this.field_70180_af.func_187214_a(DATA_INVULNERABLE, (Object)false);
        this.field_70180_af.func_187214_a(DATA_HUNGER, (Object)0);
        this.field_70180_af.func_187214_a(DATA_FAVORABILITY, (Object)0);
        this.field_70180_af.func_187214_a(DATA_EXPERIENCE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_STRUCK_BY_LIGHTNING, (Object)false);
        this.field_70180_af.func_187214_a(DATA_IS_CHARGING_CROSSBOW, (Object)false);
        this.field_70180_af.func_187214_a(DATA_ARM_RISE, (Object)false);
        this.field_70180_af.func_187214_a(SCHEDULE_MODE, (Object)MaidSchedule.DAY);
        this.field_70180_af.func_187214_a(RESTRICT_CENTER, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(RESTRICT_RADIUS, (Object)Float.valueOf(((Integer)MaidConfig.MAID_NON_HOME_RANGE.get()).floatValue()));
        this.field_70180_af.func_187214_a(CHAT_BUBBLE, (Object)MaidChatBubbles.DEFAULT);
        this.field_70180_af.func_187214_a(BACKPACK_TYPE, (Object)EmptyBackpack.ID.toString());
        this.field_70180_af.func_187214_a(BACKPACK_ITEM_SHOW, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(BACKPACK_FLUID, (Object)"");
        this.field_70180_af.func_187214_a(GAME_SKILL, (Object)new CompoundNBT());
    }

    public Brain<EntityMaid> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected Brain.BrainCodec<EntityMaid> func_230289_cH_() {
        return Brain.func_233705_a_(MaidBrain.getMemoryTypes(), MaidBrain.getSensorTypes());
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        Brain brain = this.func_230289_cH_().func_233748_a_(dynamicIn);
        MaidBrain.registerBrainGoals((Brain<EntityMaid>)brain, this);
        return brain;
    }

    public void refreshBrain(ServerWorld serverWorldIn) {
        Brain<EntityMaid> brain = this.func_213375_cj();
        brain.func_218227_b(serverWorldIn, (LivingEntity)this);
        this.field_213378_br = brain.func_218185_f();
        MaidBrain.registerBrainGoals(this.func_213375_cj(), this);
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("maidBrain");
        if (!this.guiOpening) {
            this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        super.func_70619_bc();
    }

    public void func_70071_h_() {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MaidTickEvent(this))) {
            super.func_70071_h_();
            this.maidBauble.fireEvent((b, s) -> {
                b.onTick(this, (ItemStack)s);
                return false;
            });
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.backpackDelay > 0) {
            --this.backpackDelay;
        }
        if (this.playerHurtSoundCount > 0) {
            --this.playerHurtSoundCount;
        }
        this.spawnPortalParticle();
        this.randomRestoreHealth();
        this.onMaidSleep();
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() != null) {
            Entity vehicle = this.func_184187_bx();
            this.func_70034_d(vehicle.field_70177_z);
            this.func_181013_g(vehicle.field_70177_z);
        }
    }

    private void onMaidSleep() {
        if (this.func_70608_bn()) {
            this.func_213374_dv().ifPresent(pos -> this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.8, (double)pos.func_177952_p() + 0.5));
            this.func_213317_d(Vector3d.field_186680_a);
            if (!this.func_174814_R()) {
                this.func_174810_b(true);
            }
        } else if (this.func_174814_R()) {
            this.func_174810_b(false);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
        if (!this.field_70170_p.field_72995_K) {
            ChatBubbleManger.tick(this);
            if (this.backpackData != null) {
                this.field_70170_p.func_217381_Z().func_76320_a("maidBackpackData");
                this.backpackData.serverTick(this);
                this.field_70170_p.func_217381_Z().func_76319_b();
            }
            this.field_70170_p.func_217381_Z().func_76320_a("maidFavorability");
            this.favorabilityManager.tick();
            this.field_70170_p.func_217381_Z().func_76319_b();
            this.field_70170_p.func_217381_Z().func_76320_a("maidSchedulePos");
            this.schedulePos.tick(this);
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        if (hand == Hand.MAIN_HAND && this.func_152114_e((LivingEntity)playerIn)) {
            ItemStack stack = playerIn.func_184614_ca();
            InteractMaidEvent event = new InteractMaidEvent(playerIn, this, stack);
            if (MinecraftForge.EVENT_BUS.post((Event)event) || stack.func_111282_a_(playerIn, (LivingEntity)this, hand).func_226246_a_() || this.openMaidGui(playerIn)) {
                return ActionResultType.SUCCESS;
            }
        } else {
            return this.tameMaid(playerIn.func_184586_b(hand), playerIn);
        }
        return ActionResultType.PASS;
    }

    private ActionResultType tameMaid(ItemStack stack, PlayerEntity player) {
        return player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP).map(cap -> {
            if (cap.canAdd() || player.func_184812_l_()) {
                boolean isNormal = !this.func_70909_n() && this.getTamedItem().test(stack);
                boolean isNtr = this.getNtrItem().test(stack);
                if (isNormal || isNtr) {
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                        cap.add();
                    }
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    this.func_184185_a((SoundEvent)InitSounds.MAID_TAMED.get(), 1.0f, 1.0f);
                    return ActionResultType.SUCCESS;
                }
            } else if (player instanceof ServerPlayerEntity) {
                TranslationTextComponent msg = new TranslationTextComponent("message.touhou_little_maid.owner_maid_num.can_not_add", new Object[]{cap.get(), cap.getMaxNum()});
                ((ServerPlayerEntity)player).func_241151_a_((ITextComponent)msg, ChatType.GAME_INFO, Util.field_240973_b_);
            }
            return ActionResultType.PASS;
        }).orElse(ActionResultType.PASS);
    }

    protected void func_85033_bc() {
        List entityList;
        super.func_85033_bc();
        if (this.isPickup() && this.func_70909_n() && !(entityList = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b(0.5, 0.0, 0.5), this::canPickup)).isEmpty() && this.func_70089_S()) {
            for (Entity entityPickup : entityList) {
                if (entityPickup instanceof ItemEntity) {
                    this.pickupItem((ItemEntity)entityPickup, false);
                }
                if (entityPickup instanceof ExperienceOrbEntity) {
                    this.pickupXPOrb((ExperienceOrbEntity)entityPickup);
                }
                if (entityPickup instanceof EntityPowerPoint) {
                    this.pickupPowerPoint((EntityPowerPoint)entityPickup);
                }
                if (!(entityPickup instanceof AbstractArrowEntity)) continue;
                this.pickupArrow((AbstractArrowEntity)entityPickup, false);
            }
        }
    }

    public boolean pickupItem(ItemEntity entityItem, boolean simulate) {
        if (!this.field_70170_p.field_72995_K && entityItem.func_70089_S() && !entityItem.func_174874_s()) {
            ItemStack itemstack = entityItem.func_92059_d();
            if (!EntityMaid.canInsertItem(itemstack)) {
                return false;
            }
            int count = itemstack.func_190916_E();
            if (count == (itemstack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableInv(false), (ItemStack)itemstack, (boolean)simulate)).func_190916_E()) {
                return false;
            }
            if (!simulate) {
                this.func_71001_a((Entity)entityItem, count - itemstack.func_190916_E());
                if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
                    --this.pickupSoundCount;
                    if (this.pickupSoundCount == 0) {
                        this.func_184185_a((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                        this.pickupSoundCount = 5;
                    }
                }
                if (itemstack.func_190926_b()) {
                    entityItem.func_70106_y();
                } else {
                    entityItem.func_92058_a(itemstack);
                }
            }
            return true;
        }
        return false;
    }

    public void pickupXPOrb(ExperienceOrbEntity entityXPOrb) {
        if (!this.field_70170_p.field_72995_K && entityXPOrb.func_70089_S() && entityXPOrb.field_70533_a > 2) {
            ItemStack itemstack;
            Map.Entry entry;
            this.func_71001_a((Entity)entityXPOrb, 1);
            if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
                --this.pickupSoundCount;
                if (this.pickupSoundCount == 0) {
                    this.func_184185_a((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                    this.pickupSoundCount = 5;
                }
            }
            if ((entry = EnchantmentHelper.func_234844_a_((Enchantment)Enchantments.field_185296_A, (LivingEntity)this, ItemStack::func_77951_h)) != null && !(itemstack = (ItemStack)entry.getValue()).func_190926_b() && itemstack.func_77951_h()) {
                int i = Math.min((int)((float)entityXPOrb.field_70530_e * itemstack.getXpRepairRatio()), itemstack.func_77952_i());
                entityXPOrb.field_70530_e -= i / 2;
                itemstack.func_196085_b(itemstack.func_77952_i() - i);
            }
            if (entityXPOrb.field_70530_e > 0) {
                this.setExperience(this.getExperience() + entityXPOrb.field_70530_e);
            }
            entityXPOrb.func_70106_y();
        }
    }

    public void pickupPowerPoint(EntityPowerPoint powerPoint) {
        if (!this.field_70170_p.field_72995_K && powerPoint.func_70089_S() && powerPoint.throwTime == 0) {
            powerPoint.take((Entity)this, 1);
            if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
                --this.pickupSoundCount;
                if (this.pickupSoundCount == 0) {
                    this.func_184185_a((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                    this.pickupSoundCount = 5;
                }
            }
            ItemStack itemstack = this.getRandomItemWithMendingEnchantments();
            int xpValue = EntityPowerPoint.transPowerValueToXpValue(powerPoint.getValue());
            if (!itemstack.func_190926_b() && !itemstack.func_190926_b() && itemstack.func_77951_h()) {
                int i = Math.min((int)((float)xpValue * itemstack.getXpRepairRatio()), itemstack.func_77952_i());
                xpValue -= i / 2;
                itemstack.func_196085_b(itemstack.func_77952_i() - i);
            }
            if (xpValue > 0) {
                this.setExperience(this.getExperience() + xpValue);
            }
            powerPoint.func_70106_y();
        }
    }

    private ItemStack getRandomItemWithMendingEnchantments() {
        ArrayList stacks = Lists.newArrayList();
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack itemstack = cap.getStackInSlot(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)itemstack) <= 0 || !itemstack.func_77951_h()) continue;
                stacks.add(itemstack);
            }
        });
        return stacks.isEmpty() ? ItemStack.field_190927_a : (ItemStack)stacks.get(this.func_70681_au().nextInt(stacks.size()));
    }

    public boolean pickupArrow(AbstractArrowEntity arrow, boolean simulate) {
        if (!this.field_70170_p.field_72995_K && arrow.func_70089_S() && arrow.field_70249_b <= 0) {
            if (arrow.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED) {
                return false;
            }
            ItemStack stack = this.getArrowFromEntity(arrow);
            if (stack.func_190926_b()) {
                return false;
            }
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableInv(false), (ItemStack)stack, (boolean)simulate).func_190926_b()) {
                return false;
            }
            if (!simulate) {
                this.func_71001_a((Entity)arrow, 1);
                if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
                    --this.pickupSoundCount;
                    if (this.pickupSoundCount == 0) {
                        this.func_184185_a((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                        this.pickupSoundCount = 5;
                    }
                }
                arrow.func_70106_y();
            }
            return true;
        }
        return false;
    }

    private ItemStack getArrowFromEntity(AbstractArrowEntity entity) {
        MixinArrowEntity mixinArrow;
        if (entity instanceof MixinArrowEntity && ((mixinArrow = (MixinArrowEntity)entity).tlmInGround() || entity.func_203047_q())) {
            return mixinArrow.getTlmPickupItem();
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean result = super.func_70652_k(entityIn);
        this.func_184614_ca().func_222118_a(1, (LivingEntity)this, maid -> maid.func_213334_d(Hand.MAIN_HAND));
        if (this.getTask() instanceof IAttackTask && ((IAttackTask)this.getTask()).hasExtraAttack(this, entityIn)) {
            IAttackTask attackTask = (IAttackTask)this.getTask();
            boolean extraResult = attackTask.doExtraAttack(this, entityIn);
            return result && extraResult;
        }
        return result;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidAttackEvent(this, source, amount))) {
            return false;
        }
        if (source.func_76346_g() instanceof PlayerEntity && this.func_152114_e((LivingEntity)((PlayerEntity)source.func_76346_g()))) {
            amount = MathHelper.func_76131_a((float)(amount / 5.0f), (float)0.0f, (float)2.0f);
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (!this.func_180431_b(damageSrc)) {
            MaidHurtEvent maidHurtEvent = new MaidHurtEvent(this, damageSrc, damageAmount);
            damageAmount = MinecraftForge.EVENT_BUS.post((Event)maidHurtEvent) ? 0.0f : maidHurtEvent.getAmount();
            if ((damageAmount = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)damageSrc, (float)damageAmount)) > 0.0f) {
                MaidDamageEvent maidDamageEvent;
                damageAmount = this.func_70655_b(damageSrc, damageAmount);
                damageAmount = this.func_70672_c(damageSrc, damageAmount);
                float damageAfterAbsorption = Math.max(damageAmount - this.func_110139_bj(), 0.0f);
                this.func_110149_m(this.func_110139_bj() - (damageAmount - damageAfterAbsorption));
                float damageDealtAbsorbed = damageAmount - damageAfterAbsorption;
                if (0.0f < damageDealtAbsorbed && damageDealtAbsorbed < 3.4028235E37f && damageSrc.func_76346_g() instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)damageSrc.func_76346_g()).func_195067_a(Stats.field_212735_F, Math.round(damageDealtAbsorbed * 10.0f));
                }
                damageAfterAbsorption = MinecraftForge.EVENT_BUS.post((Event)(maidDamageEvent = new MaidDamageEvent(this, damageSrc, damageAfterAbsorption))) ? 0.0f : maidDamageEvent.getAmount();
                if ((damageAfterAbsorption = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)damageSrc, (float)damageAfterAbsorption)) != 0.0f) {
                    float health = this.func_110143_aJ();
                    this.func_110142_aN().func_94547_a(damageSrc, health, damageAfterAbsorption);
                    this.func_70606_j(health - damageAfterAbsorption);
                    this.func_110149_m(this.func_110139_bj() - damageAfterAbsorption);
                }
            }
        }
    }

    @Nullable
    public Entity changeDimension(ServerWorld pServer, ITeleporter teleporter) {
        int MAX_RETRY = 16;
        if (this.field_70170_p instanceof ServerWorld && this.func_70089_S()) {
            for (int i = 0; i < 16; ++i) {
                if (!TeleportHelper.teleport(this)) continue;
                this.func_195064_c(new EffectInstance(Effects.field_188423_x, 200, 1, true, false));
            }
        }
        return null;
    }

    public void onAddedToWorld() {
        MaidWorldData data;
        super.onAddedToWorld();
        if (this.func_184753_b() != null && (data = MaidWorldData.get(this.field_70170_p)) != null) {
            data.removeInfo(this);
        }
    }

    public void onRemovedFromWorld() {
        MaidWorldData data;
        super.onRemovedFromWorld();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_184753_b() != null && (data = MaidWorldData.get(this.field_70170_p)) != null) {
            data.addInfo(this);
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MaidDeathEvent(this, cause))) {
            super.func_70645_a(cause);
        }
    }

    public boolean canPickup(Entity pickupEntity, boolean checkInWater) {
        if (this.isPickup()) {
            if (checkInWater && pickupEntity.func_70090_H()) {
                return false;
            }
            if (pickupEntity instanceof ItemEntity) {
                return this.pickupItem((ItemEntity)pickupEntity, true);
            }
            if (pickupEntity instanceof AbstractArrowEntity) {
                return this.pickupArrow((AbstractArrowEntity)pickupEntity, true);
            }
            if (pickupEntity instanceof ExperienceOrbEntity) {
                return true;
            }
            return pickupEntity instanceof EntityPowerPoint;
        }
        return false;
    }

    public boolean canPickup(Entity pickupEntity) {
        return this.canPickup(pickupEntity, false);
    }

    public void func_213671_a(boolean isCharging) {
        this.field_70180_af.func_187227_b(DATA_IS_CHARGING_CROSSBOW, (Object)isCharging);
    }

    public void func_230284_a_(LivingEntity target, ItemStack crossbow, ProjectileEntity projectileEntity, float projectileAngle) {
        this.func_234279_a_((LivingEntity)this, target, projectileEntity, projectileAngle, 1.6f);
    }

    public void func_230283_U__() {
        this.field_70708_bq = 0;
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightning) {
        super.func_241841_a(world, lightning);
        if (!this.isStruckByLightning()) {
            double beforeMaxHealth = this.func_233638_c_(Attributes.field_233818_a_);
            Objects.requireNonNull(this.func_110148_a(Attributes.field_233818_a_)).func_111128_a(beforeMaxHealth + 20.0);
            this.setStruckByLightning(true);
        }
    }

    protected void func_230294_b_(DamageSource damageSource, float damage) {
        if (damage <= 0.0f) {
            return;
        }
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        for (int i = 0; i < this.armorInvWrapper.getSlots(); ++i) {
            boolean fireResistant;
            ItemStack stack = this.armorInvWrapper.getStackInSlot(i);
            boolean bl = fireResistant = damageSource.func_76347_k() && stack.func_77973_b().func_234687_u_();
            if (fireResistant || !(stack.func_77973_b() instanceof ArmorItem)) continue;
            int index = i;
            stack.func_222118_a((int)damage, (LivingEntity)this, maid -> maid.func_213361_c(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)index)));
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        IMaidTask maidTask = this.getTask();
        if (maidTask instanceof IRangedAttackTask) {
            ((IRangedAttackTask)maidTask).performRangedAttack(this, target, distanceFactor);
        }
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        return typeIn != EntityType.field_200789_c && super.func_213358_a(typeIn);
    }

    public boolean func_213336_c(LivingEntity target) {
        if (this.getTask() instanceof IAttackTask) {
            IAttackTask attackTask = (IAttackTask)this.getTask();
            return attackTask.canAttack(this, target);
        }
        return super.func_213336_c(target);
    }

    public void sendItemBreakMessage(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K) {
            NetworkHandler.sendToNearby((Entity)this, new ItemBreakMessage(this.func_145782_y(), stack));
        }
    }

    private void randomRestoreHealth() {
        if (this.func_110143_aJ() < this.func_110138_aP() && (double)this.field_70146_Z.nextFloat() < 0.0025) {
            this.func_70691_i(1.0f);
            this.spawnRestoreHealthParticle(this.field_70146_Z.nextInt(3) + 7);
        }
    }

    private void spawnPortalParticle() {
        if (this.field_70170_p.field_72995_K && this.getIsInvulnerable() && this.func_70902_q() != null) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
    }

    private void spawnRestoreHealthParticle(int particleCount) {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < particleCount; ++i) {
                double xRandom = this.field_70146_Z.nextGaussian() * 0.02;
                double yRandom = this.field_70146_Z.nextGaussian() * 0.02;
                double zRandom = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - xRandom * 10.0, this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()) - yRandom * 10.0, this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf() - zRandom * 10.0, 0.9, 0.1, 0.1);
            }
        }
    }

    public void spawnExplosionParticle() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                float mx = (this.field_70146_Z.nextFloat() - 0.5f) * 0.02f;
                float my = (this.field_70146_Z.nextFloat() - 0.5f) * 0.02f;
                float mz = (this.field_70146_Z.nextFloat() - 0.5f) * 0.02f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_() + (double)this.field_70146_Z.nextFloat() - 0.5, this.func_226278_cu_() + (double)this.field_70146_Z.nextFloat() - 0.5, this.func_226281_cx_() + (double)this.field_70146_Z.nextFloat() - 0.5, (double)mx, (double)my, (double)mz);
            }
        }
    }

    public void spawnBubbleParticle() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 8; ++i) {
                double offsetX = 2.0 * this.field_70146_Z.nextDouble() - 1.0;
                double offsetY = this.field_70146_Z.nextDouble() / 2.0;
                double offsetZ = 2.0 * this.field_70146_Z.nextDouble() - 1.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ, 0.0, 0.1, 0.0);
            }
        }
    }

    public void spawnHeartParticle() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 8; ++i) {
                double offsetX = this.field_70146_Z.nextGaussian() * 0.02;
                double offsetY = this.field_70146_Z.nextGaussian() * 0.02;
                double offsetZ = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), offsetX, offsetY, offsetZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnRankUpParticle() {
        if (this.field_70170_p.field_72995_K) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.field_71452_i.func_199281_a((Entity)this, (IParticleData)ParticleTypes.field_197604_O, 30);
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_219603_Y, this.func_184176_by(), 1.0f, 1.0f, false);
            minecraft.field_71456_v.func_238452_a_((ITextComponent)new TranslationTextComponent("message.touhou_little_maid.gomoku.rank_up.title"), null, 10, 70, 20);
            minecraft.field_71456_v.func_238452_a_(null, (ITextComponent)new TranslationTextComponent("message.touhou_little_maid.gomoku.rank_up.subtitle"), 10, 70, 20);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a(MODEL_ID_TAG, this.getModelId());
        compound.func_74778_a(SOUND_PACK_ID_TAG, this.getSoundPackId());
        compound.func_74778_a(TASK_TAG, this.getTask().getUid().toString());
        compound.func_74757_a(PICKUP_TAG, this.isPickup());
        compound.func_74757_a(HOME_TAG, this.isHomeModeEnable());
        compound.func_74757_a(RIDEABLE_TAG, this.isRideable());
        compound.func_218657_a(MAID_INVENTORY_TAG, (INBT)this.maidInv.serializeNBT());
        compound.func_218657_a(MAID_BAUBLE_INVENTORY_TAG, (INBT)this.maidBauble.serializeNBT());
        compound.func_74757_a(STRUCK_BY_LIGHTNING_TAG, this.isStruckByLightning());
        compound.func_74757_a(INVULNERABLE_TAG, this.getIsInvulnerable());
        compound.func_74768_a(HUNGER_TAG, this.getHunger());
        compound.func_74768_a(FAVORABILITY_TAG, this.getFavorability());
        compound.func_74768_a(EXPERIENCE_TAG, this.getExperience());
        compound.func_74778_a(SCHEDULE_MODE_TAG, this.getSchedule().name());
        compound.func_74778_a(MAID_BACKPACK_TYPE, this.getMaidBackpackType().getId().toString());
        compound.func_218657_a(GAME_SKILL_TAG, (INBT)this.getGameSkill());
        this.favorabilityManager.addAdditionalSaveData(compound);
        this.scriptBookManager.addAdditionalSaveData(compound);
        this.schedulePos.save(compound);
        if (this.backpackData != null) {
            CompoundNBT tag = new CompoundNBT();
            this.backpackData.save(tag, this);
            compound.func_218657_a(BACKPACK_DATA_TAG, (INBT)tag);
        } else {
            compound.func_218657_a(BACKPACK_DATA_TAG, (INBT)new CompoundNBT());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(MODEL_ID_TAG, 8)) {
            this.setModelId(compound.func_74779_i(MODEL_ID_TAG));
        }
        if (compound.func_150297_b(SOUND_PACK_ID_TAG, 8)) {
            this.setSoundPackId(compound.func_74779_i(SOUND_PACK_ID_TAG));
        }
        if (compound.func_150297_b(SCHEDULE_MODE_TAG, 8)) {
            this.setSchedule(MaidSchedule.valueOf(compound.func_74779_i(SCHEDULE_MODE_TAG)));
        }
        if (compound.func_150297_b(TASK_TAG, 8)) {
            ResourceLocation uid = new ResourceLocation(compound.func_74779_i(TASK_TAG));
            IMaidTask task = TaskManager.findTask(uid).orElse(TaskManager.getIdleTask());
            this.setTask(task);
        }
        if (compound.func_150297_b(PICKUP_TAG, 1)) {
            this.setPickup(compound.func_74767_n(PICKUP_TAG));
        }
        if (compound.func_150297_b(HOME_TAG, 1)) {
            this.setHomeModeEnable(compound.func_74767_n(HOME_TAG));
        }
        if (compound.func_150297_b(RIDEABLE_TAG, 1)) {
            this.setRideable(compound.func_74767_n(RIDEABLE_TAG));
        }
        if (compound.func_150297_b(BACKPACK_LEVEL_TAG, 3)) {
            int backpackLevel = compound.func_74762_e(BACKPACK_LEVEL_TAG);
            if (backpackLevel == 1) {
                BackpackManager.findBackpack(SmallBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            if (backpackLevel == 2) {
                BackpackManager.findBackpack(MiddleBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            if (backpackLevel == 3) {
                BackpackManager.findBackpack(BigBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            compound.func_82580_o(BACKPACK_LEVEL_TAG);
        }
        if (compound.func_150297_b(MAID_INVENTORY_TAG, 10)) {
            this.maidInv.deserializeNBT(compound.func_74775_l(MAID_INVENTORY_TAG));
        }
        if (compound.func_150297_b(MAID_BAUBLE_INVENTORY_TAG, 10)) {
            this.maidBauble.deserializeNBT(compound.func_74775_l(MAID_BAUBLE_INVENTORY_TAG));
        }
        if (compound.func_150297_b(STRUCK_BY_LIGHTNING_TAG, 1)) {
            this.setStruckByLightning(compound.func_74767_n(STRUCK_BY_LIGHTNING_TAG));
        }
        if (compound.func_150297_b(INVULNERABLE_TAG, 1)) {
            this.setEntityInvulnerable(compound.func_74767_n(INVULNERABLE_TAG));
        }
        if (compound.func_150297_b(HUNGER_TAG, 3)) {
            this.setHunger(compound.func_74762_e(HUNGER_TAG));
        }
        if (compound.func_150297_b(FAVORABILITY_TAG, 3)) {
            this.setFavorability(compound.func_74762_e(FAVORABILITY_TAG));
        }
        if (compound.func_150297_b(EXPERIENCE_TAG, 3)) {
            this.setExperience(compound.func_74762_e(EXPERIENCE_TAG));
        }
        if (compound.func_150297_b(GAME_SKILL_TAG, 10)) {
            this.setGameSkill(compound.func_74775_l(GAME_SKILL_TAG));
        }
        if (compound.func_150297_b(RESTRICT_CENTER_TAG, 10)) {
            BlockPos blockPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(RESTRICT_CENTER_TAG));
            this.schedulePos.setHomeModeEnable(this, blockPos);
            compound.func_82580_o(RESTRICT_CENTER_TAG);
        }
        if (compound.func_150297_b(MAID_BACKPACK_TYPE, 8)) {
            ResourceLocation id = new ResourceLocation(compound.func_74779_i(MAID_BACKPACK_TYPE));
            IMaidBackpack backpack = BackpackManager.findBackpack(id).orElse(BackpackManager.getEmptyBackpack());
            this.setMaidBackpackType(backpack);
            if (this.backpackData != null && compound.func_150297_b(BACKPACK_DATA_TAG, 10)) {
                this.backpackData.load(compound.func_74775_l(BACKPACK_DATA_TAG), this);
            }
        }
        this.favorabilityManager.readAdditionalSaveData(compound);
        this.scriptBookManager.readAdditionalSaveData(compound);
        this.schedulePos.load(compound, this);
        this.setBackpackShowItem(this.maidInv.getStackInSlot(5));
    }

    public boolean openMaidGui(PlayerEntity player) {
        return this.openMaidGui(player, 0);
    }

    public boolean openMaidGui(PlayerEntity player, int tabIndex) {
        if (player instanceof ServerPlayerEntity && !this.func_70608_bn()) {
            this.field_70699_by.func_75499_g();
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.getGuiProvider(tabIndex), buffer -> buffer.writeInt(this.func_145782_y()));
        }
        return true;
    }

    private INamedContainerProvider getGuiProvider(int tabIndex) {
        switch (tabIndex) {
            case 5: {
                return MaidConfigContainer.create(this.func_145782_y());
            }
        }
        return this.getMaidBackpackType().getGuiProvider(this.func_145782_y());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.maidInv, this.maidBauble})).cast();
            }
            if (facing.func_176740_k().func_200128_b()) {
                return LazyOptional.of(() -> this.handsInvWrapper).cast();
            }
            if (facing.func_176740_k().func_176722_c()) {
                return LazyOptional.of(() -> this.armorInvWrapper).cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    protected void func_213337_cE() {
        if (this.func_184753_b() != null && !this.field_70170_p.field_72995_K) {
            Vector3d position = Vector3d.func_237492_c_((Vector3i)this.func_233580_cy_());
            if (this.func_226278_cu_() < 5.0) {
                position = new Vector3d(position.field_72450_a, 5.0, position.field_72449_c);
            }
            if (this.func_226278_cu_() > (double)this.field_70170_p.func_217301_I()) {
                position = new Vector3d(position.field_72450_a, (double)this.field_70170_p.func_217301_I(), position.field_72449_c);
            }
            EntityTombstone tombstone = new EntityTombstone(this.field_70170_p, this.func_184753_b(), position);
            tombstone.setMaidName(this.func_145748_c_());
            CombinedInvWrapper invWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.maidInv, this.maidBauble});
            for (int i = 0; i < invWrapper.getSlots(); ++i) {
                int size = invWrapper.getSlotLimit(i);
                tombstone.insertItem(invWrapper.extractItem(i, size, false));
            }
            IMaidBackpack maidBackpack = this.getMaidBackpackType();
            tombstone.insertItem(maidBackpack.getTakeOffItemStack(ItemStack.field_190927_a, null, this));
            maidBackpack.onSpawnTombstone(this, tombstone);
            ItemStack filmItem = ItemFilm.maidToFilm(this);
            tombstone.insertItem(filmItem);
            MaidWorldData maidWorldData = MaidWorldData.get(this.field_70170_p);
            if (maidWorldData != null) {
                maidWorldData.addTombstones(this, tombstone);
            }
            this.field_70170_p.func_217376_c((Entity)tombstone);
        }
    }

    protected boolean func_70684_aJ() {
        return true;
    }

    protected int func_70693_a(PlayerEntity player) {
        return this.getExperience();
    }

    protected ITextComponent func_225513_by_() {
        Optional<MaidModelInfo> info = ServerCustomPackLoader.SERVER_MAID_MODELS.getInfo(this.getModelId());
        return info.map(maidModelInfo -> ParseI18n.parse(maidModelInfo.getName())).orElseGet(() -> this.func_200600_R().func_212546_e());
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int skipRandom = this.field_70146_Z.nextInt(ServerCustomPackLoader.SERVER_MAID_MODELS.getModelSize());
        Optional modelId = ServerCustomPackLoader.SERVER_MAID_MODELS.getModelIdSet().stream().skip(skipRandom).findFirst();
        return modelId.map(id -> {
            this.setModelId((String)id);
            return spawnDataIn;
        }).orElse(spawnDataIn);
    }

    public void func_184185_a(SoundEvent soundEvent, float volume, float pitch) {
        ResourceLocation id = ForgeRegistries.SOUND_EVENTS.getKey((IForgeRegistryEntry)soundEvent);
        if (id != null && id.func_110623_a().startsWith("maid") && !this.field_70170_p.field_72995_K) {
            NetworkHandler.sendToNearby((Entity)this, new PlayMaidSoundMessage(id, this.getSoundPackId(), this.func_145782_y()), 16);
        } else {
            super.func_184185_a(soundEvent, volume, pitch);
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
            return null;
        }
        return this.task.getAmbientSound(this);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
            return null;
        }
        if (damageSourceIn.func_76347_k()) {
            return (SoundEvent)InitSounds.MAID_HURT_FIRE.get();
        }
        if (damageSourceIn.func_76346_g() instanceof PlayerEntity) {
            if (this.playerHurtSoundCount == 0) {
                this.playerHurtSoundCount = 120;
                return (SoundEvent)InitSounds.MAID_PLAYER.get();
            }
            return null;
        }
        return (SoundEvent)InitSounds.MAID_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
            return null;
        }
        return (SoundEvent)InitSounds.MAID_DEATH.get();
    }

    protected float func_70647_i() {
        return 1.0f + this.field_70146_Z.nextFloat() * 0.1f;
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * (this.func_233684_eK_() ? 0.65f : 0.85f);
    }

    public boolean func_70631_g_() {
        return false;
    }

    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return null;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return this.func_152114_e((LivingEntity)player) && super.func_184652_a(player);
    }

    public boolean canPathReach(BlockPos pos) {
        Path path = this.func_70661_as().func_179680_a(pos, 0);
        return path != null && path.func_224771_h();
    }

    public boolean canPathReach(Entity entity) {
        Path path = this.func_70661_as().func_75494_a(entity, 0);
        return path != null && path.func_224771_h();
    }

    public boolean func_230280_a_(ShootableItem shootableItem) {
        return this.getTask() instanceof IRangedAttackTask;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        BedrockModel model = CustomPackLoader.MAID_MODELS.getModel(this.getModelId()).orElse(null);
        if (model == null) {
            return super.func_184177_bl();
        }
        return model.getRenderBoundingBox().func_191194_a(this.func_213303_ch());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        Optional<BedrockModel<EntityMaid>> modelOptional = CustomPackLoader.MAID_MODELS.getModel(this.getModelId());
        Optional<MaidModelInfo> infoOptional = CustomPackLoader.MAID_MODELS.getInfo(this.getModelId());
        if (modelOptional.isPresent() && infoOptional.isPresent()) {
            BedrockModel<EntityMaid> model = modelOptional.get();
            float renderEntityScale = infoOptional.get().getRenderEntityScale();
            if (model.hasHead()) {
                ModelRenderer head = model.getHead();
                return new Vector3d((double)(head.field_78800_c * renderEntityScale), (1.5 - (double)(head.field_78797_d / 16.0f)) * (double)renderEntityScale, (double)(head.field_78798_e * renderEntityScale));
            }
        }
        return super.func_241205_ce_();
    }

    public void func_184609_a(Hand pHand) {
        SlashBladeCompat.swingSlashBlade(this, this.func_184586_b(pHand));
        super.func_184609_a(pHand);
    }

    public void func_213342_e(BlockPos pPos) {
        super.func_213342_e(pPos);
        this.func_70606_j(this.func_110138_aP());
        this.favorabilityManager.apply(Type.SLEEP);
    }

    public void setBackpackDelay() {
        this.backpackDelay = 20;
    }

    public boolean backpackHasDelay() {
        return this.backpackDelay > 0;
    }

    public String getModelId() {
        return (String)this.field_70180_af.func_187225_a(DATA_MODEL_ID);
    }

    public void setModelId(String modelId) {
        this.field_70180_af.func_187227_b(DATA_MODEL_ID, (Object)modelId);
    }

    public String getSoundPackId() {
        return (String)this.field_70180_af.func_187225_a(DATA_SOUND_PACK_ID);
    }

    public void setSoundPackId(String soundPackId) {
        this.field_70180_af.func_187227_b(DATA_SOUND_PACK_ID, (Object)soundPackId);
    }

    public boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_BEGGING);
    }

    public void setBegging(boolean begging) {
        this.field_70180_af.func_187227_b(DATA_BEGGING, (Object)begging);
    }

    public boolean isHomeModeEnable() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_HOME_MODE);
    }

    public void setHomeModeEnable(boolean enable) {
        this.field_70180_af.func_187227_b(DATA_HOME_MODE, (Object)enable);
    }

    public boolean func_213383_dH() {
        return this.func_213389_a(this.func_233580_cy_());
    }

    public boolean func_213389_a(BlockPos pos) {
        if (this.func_213394_dL()) {
            return this.func_213384_dI().func_177951_i((Vector3i)pos) < (double)(this.func_213391_dJ() * this.func_213391_dJ());
        }
        return true;
    }

    public void func_213390_a(BlockPos pos, int distance) {
        this.field_70180_af.func_187227_b(RESTRICT_CENTER, (Object)pos);
        this.field_70180_af.func_187227_b(RESTRICT_RADIUS, (Object)Float.valueOf(distance));
    }

    public BlockPos func_213384_dI() {
        return (BlockPos)this.field_70180_af.func_187225_a(RESTRICT_CENTER);
    }

    public float func_213391_dJ() {
        return ((Float)this.field_70180_af.func_187225_a(RESTRICT_RADIUS)).floatValue();
    }

    public void clearRestriction() {
        this.schedulePos.clear(this);
    }

    public boolean func_213394_dL() {
        return this.isHomeModeEnable();
    }

    public BlockPos getBrainSearchPos() {
        if (this.func_213394_dL()) {
            return this.func_213384_dI();
        }
        return this.func_233580_cy_();
    }

    public boolean canBrainMoving() {
        return !this.func_233684_eK_() && !this.func_184218_aH() && !this.func_70608_bn() && !this.func_110167_bD();
    }

    public MaidChatBubbles getChatBubble() {
        return (MaidChatBubbles)this.field_70180_af.func_187225_a(CHAT_BUBBLE);
    }

    public void setChatBubble(MaidChatBubbles bubbles) {
        this.field_70180_af.func_187227_b(CHAT_BUBBLE, (Object)bubbles);
    }

    public void addChatBubble(long endTime, ChatText text) {
        ChatBubbleManger.addChatBubble(endTime, text, this);
    }

    public int getChatBubbleCount() {
        return ChatBubbleManger.getChatBubbleCount(this);
    }

    public MaidScriptBookManager getScriptBookManager() {
        return this.scriptBookManager;
    }

    public boolean isPickup() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_PICKUP);
    }

    public void setPickup(boolean isPickup) {
        this.field_70180_af.func_187227_b(DATA_PICKUP, (Object)isPickup);
    }

    public boolean isRideable() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_RIDEABLE);
    }

    public void setRideable(boolean rideable) {
        this.field_70180_af.func_187227_b(DATA_RIDEABLE, (Object)rideable);
    }

    public boolean hasBackpack() {
        return this.getMaidBackpackType() != BackpackManager.getEmptyBackpack();
    }

    public int getHunger() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_HUNGER);
    }

    public void setHunger(int hunger) {
        this.field_70180_af.func_187227_b(DATA_HUNGER, (Object)hunger);
    }

    public int getFavorability() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_FAVORABILITY);
    }

    public void setFavorability(int favorability) {
        this.field_70180_af.func_187227_b(DATA_FAVORABILITY, (Object)favorability);
    }

    public int getExperience() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_EXPERIENCE);
    }

    public void setExperience(int experience) {
        this.field_70180_af.func_187227_b(DATA_EXPERIENCE, (Object)experience);
    }

    public boolean isStruckByLightning() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_STRUCK_BY_LIGHTNING);
    }

    public void setStruckByLightning(boolean isStruck) {
        this.field_70180_af.func_187227_b(DATA_STRUCK_BY_LIGHTNING, (Object)isStruck);
    }

    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_ARM_RISE);
    }

    public void setSwingingArms(boolean swingingArms) {
        this.field_70180_af.func_187227_b(DATA_ARM_RISE, (Object)swingingArms);
    }

    public String getBackpackFluid() {
        return (String)this.field_70180_af.func_187225_a(BACKPACK_FLUID);
    }

    public void setBackpackFluid(String fluidName) {
        this.field_70180_af.func_187227_b(BACKPACK_FLUID, (Object)fluidName);
    }

    public MaidSchedule getSchedule() {
        return (MaidSchedule)((Object)this.field_70180_af.func_187225_a(SCHEDULE_MODE));
    }

    public Activity getScheduleDetail() {
        MaidSchedule schedule = this.getSchedule();
        int time = (int)(this.field_70170_p.func_72820_D() % 24000L);
        switch (schedule) {
            case ALL: {
                return Activity.field_221367_c;
            }
            case NIGHT: {
                return ((Schedule)InitEntities.MAID_NIGHT_SHIFT_SCHEDULES.get()).func_221377_a(time);
            }
        }
        return ((Schedule)InitEntities.MAID_DAY_SHIFT_SCHEDULES.get()).func_221377_a(time);
    }

    public SchedulePos getSchedulePos() {
        return this.schedulePos;
    }

    public void setSchedule(MaidSchedule schedule) {
        this.field_70180_af.func_187227_b(SCHEDULE_MODE, (Object)schedule);
        if (this.field_70170_p instanceof ServerWorld) {
            this.refreshBrain((ServerWorld)this.field_70170_p);
        }
    }

    public ItemStack getBackpackShowItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(BACKPACK_ITEM_SHOW);
    }

    public void setBackpackShowItem(ItemStack stack) {
        this.field_70180_af.func_187227_b(BACKPACK_ITEM_SHOW, (Object)stack);
    }

    public IMaidBackpack getMaidBackpackType() {
        ResourceLocation id = new ResourceLocation((String)this.field_70180_af.func_187225_a(BACKPACK_TYPE));
        return BackpackManager.findBackpack(id).orElse(BackpackManager.getEmptyBackpack());
    }

    public void setMaidBackpackType(IMaidBackpack backpack) {
        if (backpack == this.backpack) {
            return;
        }
        this.backpack = backpack;
        this.backpackData = this.backpack.hasBackpackData() ? this.backpack.getBackpackData(this) : null;
        this.field_70180_af.func_187227_b(BACKPACK_TYPE, (Object)backpack.getId().toString());
    }

    public IBackpackData getBackpackData() {
        return this.backpackData;
    }

    public ItemStackHandler getMaidInv() {
        return this.maidInv;
    }

    public CombinedInvWrapper getAvailableInv(boolean handsFirst) {
        RangedWrapper combinedInvWrapper = new RangedWrapper((IItemHandlerModifiable)this.maidInv, 0, this.getMaidBackpackType().getAvailableMaxContainerIndex());
        return handsFirst ? new CombinedInvWrapper(new IItemHandlerModifiable[]{this.handsInvWrapper, combinedInvWrapper}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{combinedInvWrapper, this.handsInvWrapper});
    }

    public BaubleItemHandler getMaidBauble() {
        return this.maidBauble;
    }

    public boolean getIsInvulnerable() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_INVULNERABLE);
    }

    public void setEntityInvulnerable(boolean isInvulnerable) {
        super.func_184224_h(isInvulnerable);
        this.field_70180_af.func_187227_b(DATA_INVULNERABLE, (Object)isInvulnerable);
    }

    public IMaidTask getTask() {
        ResourceLocation uid = new ResourceLocation((String)this.field_70180_af.func_187225_a(DATA_TASK));
        return TaskManager.findTask(uid).orElse(TaskManager.getIdleTask());
    }

    public void setTask(IMaidTask task) {
        if (task == this.task) {
            return;
        }
        this.task = task;
        this.field_70180_af.func_187227_b(DATA_TASK, (Object)task.getUid().toString());
        if (this.field_70170_p instanceof ServerWorld) {
            this.refreshBrain((ServerWorld)this.field_70170_p);
        }
    }

    public void func_233686_v_(boolean inSittingPose) {
        super.func_233686_v_(inSittingPose);
        this.func_233687_w_(inSittingPose);
    }

    public CompoundNBT getGameSkill() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(GAME_SKILL);
    }

    public void setGameSkill(CompoundNBT gameSkill) {
        this.forceSyncData(GAME_SKILL, gameSkill, true);
    }

    public <T> void forceSyncData(DataParameter<T> key, T value, boolean force) {
        EntityDataManager.DataEntry entry = this.field_70180_af.func_187219_c(key);
        if (force || ObjectUtils.notEqual(value, (Object)entry.func_187206_b())) {
            entry.func_187210_a(value);
            this.field_70180_af.field_187233_b.func_184206_a(key);
            entry.func_187208_a(true);
            this.field_70180_af.field_187237_f = true;
        }
    }

    public boolean hasHelmet() {
        return !this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b();
    }

    public boolean hasChestPlate() {
        return !this.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
    }

    public boolean hasLeggings() {
        return !this.func_184582_a(EquipmentSlotType.LEGS).func_190926_b();
    }

    public boolean hasBoots() {
        return !this.func_184582_a(EquipmentSlotType.FEET).func_190926_b();
    }

    public boolean onHurt() {
        return this.field_70737_aN > 0;
    }

    public List<SendEffectMessage.EffectData> getEffects() {
        return this.effects;
    }

    public void setEffects(List<SendEffectMessage.EffectData> effects) {
        this.effects = effects;
    }

    @Deprecated
    public boolean hasSasimono() {
        return false;
    }

    public boolean canDestroyBlock(BlockPos pos) {
        BlockState state = this.field_70170_p.func_180495_p(pos);
        return state.func_177230_c().canEntityDestroy(state, (IBlockReader)this.field_70170_p, pos, (Entity)this) && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)pos, (BlockState)state);
    }

    public boolean canPlaceBlock(BlockPos pos) {
        BlockState oldState = this.field_70170_p.func_180495_p(pos);
        return oldState.func_185904_a().func_76222_j();
    }

    public boolean destroyBlock(BlockPos pos) {
        return this.destroyBlock(pos, true);
    }

    public boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        return this.canDestroyBlock(pos) && this.field_70170_p.func_225521_a_(pos, dropBlock, (Entity)this);
    }

    public boolean placeItemBlock(Hand hand, BlockPos placePos, Direction direction, ItemStack stack) {
        if (stack.func_77973_b() instanceof BlockItem) {
            return ((BlockItem)stack.func_77973_b()).func_195942_a(new BlockItemUseContext(this.field_70170_p, null, hand, stack, this.getBlockRayTraceResult(placePos, direction))).func_226246_a_();
        }
        return false;
    }

    public boolean placeItemBlock(BlockPos placePos, Direction direction, ItemStack stack) {
        return this.placeItemBlock(Hand.MAIN_HAND, placePos, direction, stack);
    }

    public boolean placeItemBlock(BlockPos placePos, ItemStack stack) {
        return this.placeItemBlock(placePos, Direction.UP, stack);
    }

    private BlockRayTraceResult getBlockRayTraceResult(BlockPos pos, Direction direction) {
        return new BlockRayTraceResult(new Vector3d((double)pos.func_177958_n() + 0.5 + (double)direction.func_82601_c() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)direction.func_96559_d() * 0.5, (double)pos.func_177952_p() + 0.5 + (double)direction.func_82599_e() * 0.5), direction, pos, false);
    }

    @Deprecated
    public String getAtBiomeTemp() {
        float temp = BiomeCacheUtil.getCacheBiome((Entity)this).func_242445_k();
        if ((double)temp < 0.15) {
            return "COLD";
        }
        if ((double)temp < 0.55) {
            return "OCEAN";
        }
        if ((double)temp < 0.95) {
            return "MEDIUM";
        }
        return "WARM";
    }

    @Deprecated
    public boolean isSitInJoyBlock() {
        return false;
    }

    public FavorabilityManager getFavorabilityManager() {
        return this.favorabilityManager;
    }

    @Deprecated
    public int getDim() {
        RegistryKey dim = this.field_70170_p.func_234923_W_();
        if (dim.equals(World.field_234918_g_)) {
            return 0;
        }
        if (dim.equals(World.field_234919_h_)) {
            return -1;
        }
        if (dim.equals(World.field_234920_i_)) {
            return 1;
        }
        return 0;
    }

    public Ingredient getTamedItem() {
        return this.getConfigIngredient((String)MaidConfig.MAID_TAMED_ITEM.get(), Items.field_222070_lD);
    }

    public Ingredient getTemptationItem() {
        return this.getConfigIngredient((String)MaidConfig.MAID_TEMPTATION_ITEM.get(), Items.field_222070_lD);
    }

    public Ingredient getNtrItem() {
        return this.getConfigIngredient((String)MaidConfig.MAID_NTR_ITEM.get(), Items.field_221966_go);
    }

    private Ingredient getConfigIngredient(String config, Item defaultItem) {
        if (config.startsWith("#")) {
            ResourceLocation key = new ResourceLocation(config.substring(1));
            ITag tag = ItemTags.func_199903_a().func_199910_a(key);
            if (tag != null) {
                return Ingredient.func_199805_a((ITag)tag);
            }
        } else {
            ResourceLocation key = new ResourceLocation(config);
            if (ForgeRegistries.ITEMS.containsKey(key)) {
                return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(key)});
            }
        }
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{defaultItem});
    }
}

