/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.TeleportHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public final class SchedulePos {
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;
    private BlockPos workPos;
    private BlockPos idlePos;
    private BlockPos sleepPos;
    private ResourceLocation dimension;
    private boolean configured = false;

    public SchedulePos(BlockPos workPos, BlockPos idlePos, BlockPos sleepPos, ResourceLocation dimension) {
        this.workPos = workPos;
        this.idlePos = idlePos;
        this.sleepPos = sleepPos;
        this.dimension = dimension;
    }

    public SchedulePos(BlockPos workPos, BlockPos idlePos, ResourceLocation dimension) {
        this(workPos, idlePos, idlePos, dimension);
    }

    public SchedulePos(BlockPos workPos, ResourceLocation dimension) {
        this(workPos, workPos, dimension);
    }

    public void setWorkPos(BlockPos workPos) {
        this.workPos = workPos;
    }

    public void setIdlePos(BlockPos idlePos) {
        this.idlePos = idlePos;
    }

    public void setSleepPos(BlockPos sleepPos) {
        this.sleepPos = sleepPos;
    }

    public void setDimension(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    public void tick(EntityMaid maid) {
        if (maid.field_70173_aa % 40 == 0) {
            int minTeleportDistance;
            this.restrictTo(maid);
            if (maid.func_213383_dH()) {
                return;
            }
            if (!maid.canBrainMoving()) {
                return;
            }
            double distanceSqr = maid.func_213384_dI().func_177951_i((Vector3i)maid.func_233580_cy_());
            if (distanceSqr > (double)((minTeleportDistance = (int)maid.func_213391_dJ() + 4) * minTeleportDistance) && !this.sameWithRestrictCenter(maid)) {
                this.teleport(maid);
            } else {
                BrainUtil.func_233866_a_((LivingEntity)maid, (BlockPos)maid.func_213384_dI(), (float)0.7f, (int)3);
            }
        }
    }

    public void save(CompoundNBT compound) {
        CompoundNBT data = new CompoundNBT();
        data.func_218657_a("Work", (INBT)NBTUtil.func_186859_a((BlockPos)this.workPos));
        data.func_218657_a("Idle", (INBT)NBTUtil.func_186859_a((BlockPos)this.idlePos));
        data.func_218657_a("Sleep", (INBT)NBTUtil.func_186859_a((BlockPos)this.sleepPos));
        data.func_74778_a("Dimension", this.dimension.toString());
        data.func_74757_a("Configured", this.configured);
        compound.func_218657_a("MaidSchedulePos", (INBT)data);
    }

    public void load(CompoundNBT compound, EntityMaid maid) {
        if (compound.func_150297_b("MaidSchedulePos", 10)) {
            CompoundNBT data = compound.func_74775_l("MaidSchedulePos");
            this.workPos = NBTUtil.func_186861_c((CompoundNBT)data.func_74775_l("Work"));
            this.idlePos = NBTUtil.func_186861_c((CompoundNBT)data.func_74775_l("Idle"));
            this.sleepPos = NBTUtil.func_186861_c((CompoundNBT)data.func_74775_l("Sleep"));
            this.dimension = new ResourceLocation(data.func_74779_i("Dimension"));
            this.configured = data.func_74767_n("Configured");
            this.restrictTo(maid);
        }
    }

    public void restrictTo(EntityMaid maid) {
        Activity activity = maid.getScheduleDetail();
        if (activity == Activity.field_221367_c) {
            maid.func_213390_a(this.workPos, (Integer)MaidConfig.MAID_WORK_RANGE.get());
            return;
        }
        if (activity == Activity.field_221366_b) {
            maid.func_213390_a(this.idlePos, (Integer)MaidConfig.MAID_IDLE_RANGE.get());
            return;
        }
        if (activity == Activity.field_221369_e) {
            maid.func_213390_a(this.sleepPos, (Integer)MaidConfig.MAID_SLEEP_RANGE.get());
        }
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public BlockPos getWorkPos() {
        return this.workPos;
    }

    public BlockPos getIdlePos() {
        return this.idlePos;
    }

    public BlockPos getSleepPos() {
        return this.sleepPos;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public void clear(EntityMaid maid) {
        this.idlePos = this.workPos;
        this.sleepPos = this.workPos;
        this.configured = false;
        this.dimension = maid.field_70170_p.func_234923_W_().func_240901_a_();
        this.restrictTo(maid);
    }

    public void setHomeModeEnable(EntityMaid maid, BlockPos pos) {
        if (!this.configured) {
            this.workPos = pos;
            this.idlePos = pos;
            this.sleepPos = pos;
            this.dimension = maid.field_70170_p.func_234923_W_().func_240901_a_();
        }
        this.restrictTo(maid);
    }

    @Nullable
    public BlockPos getNearestPos(EntityMaid maid) {
        if (this.configured) {
            BlockPos pos = this.workPos;
            double workDistance = maid.func_233580_cy_().func_177951_i((Vector3i)this.workPos);
            double idleDistance = maid.func_233580_cy_().func_177951_i((Vector3i)this.idlePos);
            double sleepDistance = maid.func_233580_cy_().func_177951_i((Vector3i)this.sleepPos);
            if (workDistance > idleDistance) {
                pos = this.idlePos;
                workDistance = idleDistance;
            }
            if (workDistance > sleepDistance) {
                pos = this.sleepPos;
            }
            return pos;
        }
        return null;
    }

    private boolean sameWithRestrictCenter(EntityMaid maid) {
        BlockPos restrictCenter = maid.func_213384_dI();
        return maid.func_213375_cj().func_218207_c(MemoryModuleType.field_220950_k).filter(walkTarget -> walkTarget.func_220966_a().func_220608_a().equals((Object)restrictCenter)).isPresent();
    }

    private void teleport(EntityMaid maid) {
        for (int i = 0; i < 10; ++i) {
            if (!TeleportHelper.teleportToRestrictCenter(maid)) continue;
            return;
        }
    }
}

