/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityDanmaku;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public final class DanmakuShoot {
    private static final Random RANDOM = new Random();
    private static final double MAX_YAW = Math.PI * 2;
    private static final int MIN_FAN_NUM = 2;
    private World world;
    private LivingEntity thrower;
    private DanmakuColor color;
    private DanmakuType type;
    private float gravity;
    private float damage;
    private LivingEntity target;
    private float velocity;
    private float inaccuracy;
    private double yawTotal;
    private int fanNum;

    public static DanmakuShoot create() {
        return new DanmakuShoot();
    }

    public void aimedShot() {
        if (!this.world.field_72995_K) {
            EntityDanmaku danmaku = new EntityDanmaku(this.world, this.thrower).setDamage(this.damage).setGravityVelocity(this.gravity).setDanmakuType(this.type).setColor(this.color);
            float offset = 0.3f / this.target.func_213302_cg();
            danmaku.func_70186_c(this.target.func_226277_ct_() - this.thrower.func_226277_ct_(), this.target.func_226278_cu_() - this.thrower.func_226278_cu_() - (double)offset, this.target.func_226281_cx_() - this.thrower.func_226281_cx_(), this.velocity, this.inaccuracy);
            this.world.func_217376_c((Entity)danmaku);
        }
        this.world.func_184148_a(null, this.thrower.func_226277_ct_(), this.thrower.func_226278_cu_(), this.thrower.func_226281_cx_(), SoundEvents.field_187797_fA, this.thrower.func_184176_by(), 1.0f, 0.8f);
    }

    public void fanShapedShot() {
        if (this.yawTotal < 0.0 || this.yawTotal > Math.PI * 2 || this.fanNum < 2) {
            return;
        }
        if (!this.world.field_72995_K) {
            float offset = 0.3f / this.target.func_213302_cg();
            Vector3d v = new Vector3d(this.target.func_226277_ct_() - this.thrower.func_226277_ct_(), this.target.func_226278_cu_() - this.thrower.func_226278_cu_() - (double)offset, this.target.func_226281_cx_() - this.thrower.func_226281_cx_());
            double yaw = -(this.yawTotal / 2.0);
            double addYaw = this.yawTotal / (double)(this.fanNum - 1);
            for (int i = 1; i <= this.fanNum; ++i) {
                Vector3d v1 = v.func_178785_b((float)yaw);
                yaw += addYaw;
                EntityDanmaku danmaku = new EntityDanmaku(this.world, this.thrower).setDamage(this.damage).setGravityVelocity(this.gravity).setDanmakuType(this.type).setColor(this.color);
                danmaku.func_70186_c(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, this.velocity, this.inaccuracy);
                this.world.func_217376_c((Entity)danmaku);
            }
        }
        this.world.func_184148_a(null, this.thrower.func_226277_ct_(), this.thrower.func_226278_cu_(), this.thrower.func_226281_cx_(), SoundEvents.field_187797_fA, this.thrower.func_184176_by(), 1.0f, 0.8f);
    }

    public DanmakuShoot setWorld(World world) {
        this.world = world;
        return this;
    }

    public DanmakuShoot setThrower(LivingEntity thrower) {
        this.thrower = thrower;
        return this;
    }

    public DanmakuShoot setColor(DanmakuColor color) {
        this.color = color;
        return this;
    }

    public DanmakuShoot setRandomColor() {
        this.color = DanmakuColor.random(RANDOM);
        return this;
    }

    public DanmakuShoot setType(DanmakuType type) {
        this.type = type;
        return this;
    }

    public DanmakuShoot setRandomType() {
        this.type = DanmakuType.random(RANDOM);
        return this;
    }

    public DanmakuShoot setGravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    public DanmakuShoot setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public DanmakuShoot setTarget(LivingEntity target) {
        this.target = target;
        return this;
    }

    public DanmakuShoot setVelocity(float velocity) {
        this.velocity = velocity;
        return this;
    }

    public DanmakuShoot setInaccuracy(float inaccuracy) {
        this.inaccuracy = inaccuracy;
        return this;
    }

    public DanmakuShoot setYawTotal(double yawTotal) {
        this.yawTotal = yawTotal;
        return this;
    }

    public DanmakuShoot setFanNum(int fanNum) {
        this.fanNum = fanNum;
        return this;
    }
}

