/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityDamageSourceDanmaku;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDanmaku
extends ThrowableEntity {
    public static final EntityType<EntityDanmaku> TYPE = EntityType.Builder.func_220322_a(EntityDanmaku::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(6).func_233608_b_(10).func_206830_a("danmaku");
    private static final int MAX_TICKS_EXISTED = 200;
    private static final DataParameter<Integer> DANMAKU_TYPE = EntityDataManager.func_187226_a(EntityDanmaku.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityDanmaku.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityDanmaku.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(EntityDanmaku.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final String DANMAKU_TYPE_TAG = "DanmakuType";
    private static final String DANMAKU_COLOR_TAG = "DanmakuColor";
    private static final String DANMAKU_DAMAGE_TAG = "DanmakuDamage";
    private static final String DANMAKU_GRAVITY_TAG = "DanmakuGravity";

    public EntityDanmaku(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityDanmaku(World worldIn, LivingEntity throwerIn) {
        super(TYPE, throwerIn, worldIn);
    }

    public EntityDanmaku(World worldIn, double x, double y, double z) {
        super(TYPE, x, y, z, worldIn);
    }

    private static boolean hasSameOwner(TameableEntity tameableA, TameableEntity tameableB) {
        if (tameableA.func_184753_b() == null) {
            return false;
        }
        return tameableA.func_184753_b().equals(tameableB.func_184753_b());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DANMAKU_TYPE, (Object)DanmakuType.PELLET.ordinal());
        this.field_70180_af.func_187214_a(COLOR, (Object)DanmakuColor.RED.ordinal());
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(GRAVITY, (Object)Float.valueOf(0.01f));
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        BlockPos pos = result.func_216350_a();
        BlockState blockState = this.field_70170_p.func_180495_p(pos);
        if (!blockState.func_196952_d((IBlockReader)this.field_70170_p, pos).func_197766_b()) {
            this.func_70106_y();
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity thrower = this.func_234616_v_();
        Entity hit = result.func_216348_a();
        if (thrower instanceof TameableEntity) {
            TameableEntity tameable = (TameableEntity)thrower;
            if (hit instanceof TameableEntity && EntityDanmaku.hasSameOwner(tameable, (TameableEntity)hit)) {
                this.func_70106_y();
                return;
            }
            if (hit instanceof LivingEntity && tameable.func_152114_e((LivingEntity)hit)) {
                this.func_70106_y();
                return;
            }
            ResourceLocation registryName = hit.func_200600_R().getRegistryName();
            if (registryName != null && ((List)MaidConfig.MAID_RANGED_ATTACK_IGNORE.get()).contains(registryName.toString())) {
                this.func_70106_y();
                return;
            }
        }
        if (thrower != null && !hit.func_70028_i(thrower)) {
            EntityDamageSourceDanmaku source = new EntityDamageSourceDanmaku((Entity)this, thrower);
            hit.func_70097_a((DamageSource)source, this.getDamage());
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 200) {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(DANMAKU_TYPE_TAG, 3)) {
            this.setDanmakuType(DanmakuType.getType(compound.func_74762_e(DANMAKU_TYPE_TAG)));
        }
        if (compound.func_150297_b(DANMAKU_COLOR_TAG, 3)) {
            this.setColor(DanmakuColor.getColor(compound.func_74762_e(DANMAKU_COLOR_TAG)));
        }
        if (compound.func_150297_b(DANMAKU_DAMAGE_TAG, 5)) {
            this.setDamage(compound.func_74760_g(DANMAKU_DAMAGE_TAG));
        }
        if (compound.func_150297_b(DANMAKU_GRAVITY_TAG, 5)) {
            this.setGravityVelocity(compound.func_74760_g(DANMAKU_GRAVITY_TAG));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a(DANMAKU_TYPE_TAG, this.getDanmakuType().ordinal());
        compound.func_74768_a(DANMAKU_COLOR_TAG, this.getColor().ordinal());
        compound.func_74776_a(DANMAKU_DAMAGE_TAG, this.getDamage());
        compound.func_74776_a(DANMAKU_GRAVITY_TAG, this.func_70185_h());
    }

    public boolean func_70090_H() {
        return super.func_70090_H();
    }

    protected float func_70185_h() {
        return ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
    }

    public EntityDanmaku setGravityVelocity(float gravity) {
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
        return this;
    }

    public DanmakuType getDanmakuType() {
        return DanmakuType.getType((Integer)this.field_70180_af.func_187225_a(DANMAKU_TYPE));
    }

    public EntityDanmaku setDanmakuType(DanmakuType type) {
        this.field_70180_af.func_187227_b(DANMAKU_TYPE, (Object)type.ordinal());
        return this;
    }

    public DanmakuColor getColor() {
        return DanmakuColor.getColor((Integer)this.field_70180_af.func_187225_a(COLOR));
    }

    public EntityDanmaku setColor(DanmakuColor color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color.ordinal());
        return this;
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public EntityDanmaku setDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
        return this;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

