/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityExtinguishingAgent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class TaskAttack
implements IAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "attack");
    private static final int MAX_STOP_ATTACK_DISTANCE = 8;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.field_151048_u.func_190903_i();
    }

    @Override
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_ATTACK.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, Task<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        SupplementedTask supplementedTask = new SupplementedTask(this::hasAssaultWeapon, (Task)new ForgetAttackTargetTask(IAttackTask::findFirstValidAttackTarget));
        FindNewAttackTargetTask findTargetTask = new FindNewAttackTargetTask(target -> !this.hasAssaultWeapon(maid) || this.farAway((LivingEntity)target, maid));
        MoveToTargetTask moveToTargetTask = new MoveToTargetTask(0.6f);
        AttackTargetTask attackTargetTask = new AttackTargetTask(20);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)moveToTargetTask), Pair.of((Object)5, (Object)attackTargetTask)});
    }

    @Override
    public boolean hasExtraAttack(EntityMaid maid, Entity target) {
        return maid.func_184592_cb().func_77973_b() == InitItems.EXTINGUISHER.get() && target.func_230279_az_();
    }

    @Override
    public boolean doExtraAttack(EntityMaid maid, Entity target) {
        World world = maid.field_70170_p;
        AxisAlignedBB aabb = target.func_174813_aQ().func_72314_b(1.5, 1.0, 1.5);
        List extinguishingAgents = world.func_175647_a(EntityExtinguishingAgent.class, aabb, Entity::func_70089_S);
        if (extinguishingAgents.isEmpty()) {
            world.func_217376_c((Entity)new EntityExtinguishingAgent(world, target.func_213303_ch()));
            maid.func_184592_cb().func_222118_a(1, (LivingEntity)maid, m -> m.func_213334_d(Hand.OFF_HAND));
            return true;
        }
        return false;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"assault_weapon", this::hasAssaultWeapon), Pair.of((Object)"extinguisher", this::hasExtinguisher)});
    }

    private boolean hasAssaultWeapon(EntityMaid maid) {
        return maid.func_184614_ca().func_111283_C(EquipmentSlotType.MAINHAND).containsKey((Object)Attributes.field_233823_f_);
    }

    private boolean hasExtinguisher(EntityMaid maid) {
        return maid.func_184592_cb().func_77973_b() == InitItems.EXTINGUISHER.get();
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.func_70032_d((Entity)target) > 8.0f;
    }
}

