/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TaskBowAttack
implements IRangedAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "ranged_attack");
    private static final int MAX_STOP_ATTACK_DISTANCE = 16;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.field_151031_f.func_190903_i();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_RANGE_ATTACK.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, Task<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        SupplementedTask supplementedTask = new SupplementedTask(e -> this.hasBow((EntityMaid)((Object)e)) && this.hasArrow((EntityMaid)((Object)e)), (Task)new ForgetAttackTargetTask(IAttackTask::findFirstValidAttackTarget));
        FindNewAttackTargetTask findTargetTask = new FindNewAttackTargetTask(target -> !this.hasBow(maid) || !this.hasArrow(maid) || this.farAway((LivingEntity)target, maid));
        MoveToTargetTask moveToTargetTask = new MoveToTargetTask(0.6f);
        MaidAttackStrafingTask maidAttackStrafingTask = new MaidAttackStrafingTask();
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, LivingEntity target, float distanceFactor) {
        ItemStack mainHandItem;
        AbstractArrowEntity entityArrow = this.getArrow(shooter, distanceFactor);
        if (entityArrow != null && (mainHandItem = shooter.func_184614_ca()).func_77973_b() instanceof BowItem) {
            double x = target.func_226277_ct_() - shooter.func_226277_ct_();
            double y = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - entityArrow.func_213303_ch().field_72448_b;
            double z = target.func_226281_cx_() - shooter.func_226281_cx_();
            double pitch = (double)MathHelper.func_76133_a((double)(x * x + z * z)) * 0.15;
            entityArrow.func_70186_c(x, y + pitch, z, 1.6f, 1.0f);
            mainHandItem.func_222118_a(1, (LivingEntity)shooter, maid -> maid.func_213334_d(Hand.MAIN_HAND));
            shooter.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (shooter.func_70681_au().nextFloat() * 0.4f + 0.8f));
            shooter.field_70170_p.func_217376_c((Entity)entityArrow);
        }
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"has_bow", this::hasBow), Pair.of((Object)"has_arrow", this::hasArrow)});
    }

    private boolean hasBow(EntityMaid maid) {
        return maid.func_184614_ca().func_77973_b() instanceof BowItem;
    }

    private boolean hasArrow(EntityMaid maid) {
        return this.findArrow(maid) >= 0;
    }

    private int findArrow(EntityMaid maid) {
        ItemStack mainHandItem = maid.func_184614_ca();
        if (mainHandItem.func_77973_b() instanceof BowItem) {
            CombinedInvWrapper handler = maid.getAvailableInv(true);
            return ItemsUtil.findStackSlot((IItemHandler)handler, ((BowItem)mainHandItem.func_77973_b()).func_220004_b());
        }
        return -1;
    }

    @Nullable
    private AbstractArrowEntity getArrow(EntityMaid maid, float chargeTime) {
        int slot = this.findArrow(maid);
        if (slot < 0) {
            return null;
        }
        CombinedInvWrapper handler = maid.getAvailableInv(true);
        ItemStack arrowStack = handler.getStackInSlot(slot);
        ItemStack mainHandItem = maid.func_184614_ca();
        AbstractArrowEntity arrowEntity = ProjectileHelper.func_221272_a((LivingEntity)maid, (ItemStack)arrowStack, (float)chargeTime);
        if (mainHandItem.func_77973_b() instanceof BowItem) {
            arrowEntity = ((BowItem)mainHandItem.func_77973_b()).customArrow(arrowEntity);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)mainHandItem) <= 0) {
            arrowStack.func_190918_g(1);
            handler.setStackInSlot(slot, arrowStack);
            arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
        }
        return arrowEntity;
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.func_70032_d((Entity)target) > 16.0f;
    }
}

