/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmMoveTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmPlantTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TaskCocoa
implements IFarmTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "cocoa");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.field_196130_bo.func_190903_i();
    }

    @Override
    public List<Pair<Integer, Task<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        MaidFarmMoveTask maidFarmMoveTask = new MaidFarmMoveTask(this, 0.6f){

            @Override
            protected boolean checkPathReach(EntityMaid maid, BlockPos pos) {
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 0; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            if (!maid.canPathReach(pos.func_177982_a(x, y, z))) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        MaidFarmPlantTask maidFarmPlantTask = new MaidFarmPlantTask(this);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)maidFarmMoveTask)), Pair.of((Object)6, (Object)((Object)maidFarmPlantTask))});
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        return stack.func_77973_b() == Items.field_196130_bo;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        return cropState.func_203425_a(Blocks.field_150375_by) && (Integer)cropState.func_177229_b((Property)CocoaBlock.field_176501_a) >= 2;
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        maid.destroyBlock(cropPos);
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        baseState = maid.field_70170_p.func_180495_p(basePos = basePos.func_177984_a());
        if (baseState.func_235714_a_((ITag)BlockTags.field_203289_r) && seed.func_77973_b() == Items.field_196130_bo) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState state = maid.field_70170_p.func_180495_p(basePos.func_177972_a(direction));
                if (!state.func_185904_a().func_76222_j()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        if (seed.func_77973_b() == Items.field_196130_bo) {
            basePos = basePos.func_177984_a();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos directionPos = basePos.func_177972_a(direction);
                if (seed.func_190926_b() || !maid.canPlaceBlock(directionPos)) continue;
                World world = maid.field_70170_p;
                BlockState cocoaState = (BlockState)Blocks.field_150375_by.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)direction.func_176734_d());
                world.func_180501_a(directionPos, cocoaState, 11);
                SoundType soundType = cocoaState.getSoundType((IWorldReader)world, directionPos, (Entity)maid);
                world.func_184133_a(null, directionPos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                seed.func_190918_g(1);
            }
        }
        return seed;
    }

    @Override
    public double getCloseEnoughDist() {
        return 2.5;
    }

    @Override
    public boolean checkCropPosAbove() {
        return false;
    }
}

