/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuShoot;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class TaskDanmakuAttack
implements IRangedAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "danmaku_attack");
    private static final int MAX_STOP_ATTACK_DISTANCE = 16;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return ((Item)InitItems.HAKUREI_GOHEI.get()).func_190903_i();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_DANMAKU_ATTACK.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, Task<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        SupplementedTask supplementedTask = new SupplementedTask(this::hasGohei, (Task)new ForgetAttackTargetTask(IAttackTask::findFirstValidAttackTarget));
        FindNewAttackTargetTask findTargetTask = new FindNewAttackTargetTask(target -> !this.hasGohei(maid) || this.farAway((LivingEntity)target, maid));
        MoveToTargetTask moveToTargetTask = new MoveToTargetTask(0.6f);
        MaidAttackStrafingTask maidAttackStrafingTask = new MaidAttackStrafingTask();
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, LivingEntity target, float distanceFactor) {
        shooter.func_213375_cj().func_218207_c(MemoryModuleType.field_220945_f).ifPresent(livingEntities -> {
            ItemStack mainHandItem = shooter.func_184614_ca();
            if (mainHandItem.func_77973_b() == InitItems.HAKUREI_GOHEI.get()) {
                long entityCount = livingEntities.stream().filter(shooter::func_213336_c).count();
                World level = shooter.field_70170_p;
                if (entityCount <= 1L) {
                    DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(2.0f * (distanceFactor + 1.0f)).setGravity(0.0f).setVelocity(0.3f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).aimedShot();
                } else if (entityCount <= 5L) {
                    DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(2.0f * (distanceFactor + 1.2f)).setGravity(0.0f).setVelocity(0.3f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(8).setYawTotal(1.0471975511965976).fanShapedShot();
                } else {
                    DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(2.0f * (distanceFactor + 1.5f)).setGravity(0.0f).setVelocity(0.3f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(32).setYawTotal(2.0943951023931953).fanShapedShot();
                }
                mainHandItem.func_222118_a(1, (LivingEntity)shooter, maid -> maid.func_213334_d(Hand.MAIN_HAND));
            }
        });
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_gohei", this::hasGohei));
    }

    private boolean hasGohei(EntityMaid maid) {
        return maid.func_184614_ca().func_77973_b() == InitItems.HAKUREI_GOHEI.get();
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.func_70032_d((Entity)target) > 16.0f;
    }
}

