/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFeedAnimalTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.MoveToTargetTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.items.IItemHandler;

public class TaskFeedAnimal
implements IAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "feed_animal");
    private static final int MAX_STOP_ATTACK_DISTANCE = 8;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.field_151015_O.func_190903_i();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_FEED_ANIMAL.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, Task<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        SupplementedTask supplementedTask = new SupplementedTask(this::hasAssaultWeapon, (Task)new ForgetAttackTargetTask(this::findFirstValidAttackTarget));
        FindNewAttackTargetTask findTargetTask = new FindNewAttackTargetTask(target -> !this.hasAssaultWeapon(maid) || this.farAway((LivingEntity)target, maid));
        MoveToTargetTask moveToTargetTask = new MoveToTargetTask(0.6f);
        AttackTargetTask attackTargetTask = new AttackTargetTask(20);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)new MaidFeedAnimalTask(0.6f, (int)((Integer)MaidConfig.FEED_ANIMAL_MAX_NUMBER.get())))), Pair.of((Object)6, (Object)supplementedTask), Pair.of((Object)6, (Object)findTargetTask), Pair.of((Object)6, (Object)moveToTargetTask), Pair.of((Object)6, (Object)attackTargetTask)});
    }

    @Override
    private Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        long animalCount = this.getEntities(maid).stream().filter(e -> maid.func_213389_a(e.func_233580_cy_())).filter(Entity::func_70089_S).filter(e -> e instanceof AnimalEntity).count();
        if (animalCount < (long)((Integer)MaidConfig.FEED_ANIMAL_MAX_NUMBER.get() - 2)) {
            return Optional.empty();
        }
        return this.getEntities(maid).stream().filter(e -> maid.func_213389_a(e.func_233580_cy_())).filter(Entity::func_70089_S).filter(e -> e instanceof AnimalEntity).filter(e -> ((AnimalEntity)e).func_70874_b() == 0).filter(e -> ((AnimalEntity)e).func_204701_dC()).filter(e -> ItemsUtil.isStackIn((IItemHandler)maid.getAvailableInv(false), arg_0 -> ((AnimalEntity)((AnimalEntity)e)).func_70877_b(arg_0))).filter(maid::canPathReach).findFirst();
    }

    @Override
    public boolean canAttack(EntityMaid maid, LivingEntity target) {
        return true;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"can_feed", (Object)Predicates.alwaysTrue()), Pair.of((Object)"assault_weapon", this::hasAssaultWeapon)});
    }

    private List<LivingEntity> getEntities(EntityMaid maid) {
        return maid.func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g).orElse(Collections.emptyList());
    }

    private boolean hasAssaultWeapon(EntityMaid maid) {
        return maid.func_184614_ca().func_111283_C(EquipmentSlotType.MAINHAND).containsKey((Object)Attributes.field_233823_f_);
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.func_70032_d((Entity)target) > 8.0f;
    }
}

