/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFeedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFeedOwnerTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class TaskFeedOwner
implements IFeedTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "feed");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.field_151083_be.func_190903_i();
    }

    @Override
    public boolean isFood(ItemStack stack, PlayerEntity owner) {
        if (stack.func_77973_b() == Items.field_151117_aB) {
            for (EffectInstance effect : owner.func_70651_bq()) {
                if (!this.isHarmfulEffect(effect) || effect.func_76459_b() <= 60 || !effect.isCurativeItem(stack)) continue;
                return true;
            }
            return false;
        }
        if (stack.func_77973_b().func_219967_s() != null) {
            Food food = stack.func_77973_b().func_219967_s();
            return food.func_221464_f().isEmpty() || food.func_221464_f().stream().noneMatch(pair -> this.isHarmfulEffect((EffectInstance)pair.getFirst()));
        }
        return false;
    }

    @Override
    public IFeedTask.Priority getPriority(ItemStack stack, PlayerEntity owner) {
        if (stack.func_77973_b() == Items.field_151117_aB) {
            return IFeedTask.Priority.HIGH;
        }
        if (stack.func_77973_b() == Items.field_151153_ao) {
            if (owner.func_110143_aJ() * 2.0f < owner.func_110138_aP()) {
                return IFeedTask.Priority.HIGH;
            }
            return IFeedTask.Priority.LOWEST;
        }
        if (stack.func_77973_b().func_219967_s() != null) {
            int hunger;
            Food food = stack.func_77973_b().func_219967_s();
            int heal = food.func_221466_a();
            if (heal == (hunger = 20 - owner.func_71024_bL().func_75116_a())) {
                return IFeedTask.Priority.HIGH;
            }
            if (heal > hunger) {
                return IFeedTask.Priority.LOWEST;
            }
            return IFeedTask.Priority.LOW;
        }
        return IFeedTask.Priority.NONE;
    }

    @Override
    public ItemStack feed(ItemStack stack, PlayerEntity owner) {
        if (stack.func_77975_n() == UseAction.DRINK) {
            owner.field_70170_p.func_217384_a(null, (Entity)owner, stack.func_226629_F_(), SoundCategory.NEUTRAL, 0.5f, owner.field_70170_p.func_201674_k().nextFloat() * 0.1f + 0.9f);
        }
        return stack.func_77973_b().func_77654_b(stack, owner.field_70170_p, (LivingEntity)owner);
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_FEED.get(), 0.3f);
    }

    @Override
    public List<Pair<Integer, Task<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)new MaidFeedOwnerTask(this, 2, 0.6f)))});
    }

    private boolean isHarmfulEffect(EffectInstance effect) {
        return effect.func_188419_a().func_220303_e() == EffectType.HARMFUL;
    }
}

