/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCollectHoneyTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.items.IItemHandler;

public class TaskHoney
implements IMaidTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "honey");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.field_226638_pX_.func_190903_i();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_IDLE.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, Task<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        MaidCollectHoneyTask maidCollectHoneyTask = new MaidCollectHoneyTask(0.6f, 2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)maidCollectHoneyTask))});
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"has_bottle", this::hasBottle), Pair.of((Object)"has_shears", this::hasShears)});
    }

    private boolean hasBottle(EntityMaid maid) {
        return ItemsUtil.isStackIn((IItemHandler)maid.getAvailableInv(false), stack -> stack.func_77973_b() == Items.field_151069_bo);
    }

    private boolean hasShears(EntityMaid maid) {
        return maid.func_184614_ca().func_77973_b() == Items.field_151097_aZ;
    }
}

