/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidBegTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidSnowballTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.ForgetAttackTargetTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaskIdle
implements IMaidTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "idle");
    private static final float LOW_TEMPERATURE = 0.15f;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.field_151008_G.func_190903_i();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_IDLE.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, Task<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        Pair lookToPlayer = Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 5.0f), (Object)1);
        Pair lookToMaid = Pair.of((Object)new LookAtEntityTask(EntityMaid.TYPE, 5.0f), (Object)1);
        Pair lookToWolf = Pair.of((Object)new LookAtEntityTask(EntityType.field_200724_aC, 5.0f), (Object)1);
        Pair lookToCat = Pair.of((Object)new LookAtEntityTask(EntityType.field_220360_g, 5.0f), (Object)1);
        Pair lookToParrot = Pair.of((Object)new LookAtEntityTask(EntityType.field_200783_W, 5.0f), (Object)1);
        Pair noLook = Pair.of((Object)new DummyTask(20, 40), (Object)2);
        Pair findSnowballTarget = Pair.of((Object)new ForgetAttackTargetTask(this::canSnowballFight, this::findFirstValidSnowballTarget), (Object)2);
        FirstShuffledTask firstShuffledTask = new FirstShuffledTask((List)ImmutableList.of((Object)lookToPlayer, (Object)lookToMaid, (Object)lookToWolf, (Object)lookToCat, (Object)lookToParrot, (Object)findSnowballTarget, (Object)noLook));
        SupplementedTask randomLookTask = new SupplementedTask(e -> !e.isBegging(), (Task)firstShuffledTask);
        MaidSnowballTargetTask snowballTargetTask = new MaidSnowballTargetTask(40);
        Pair beg = Pair.of((Object)5, (Object)((Object)new MaidBegTask()));
        Pair supplemented = Pair.of((Object)6, (Object)randomLookTask);
        Pair snowballFight = Pair.of((Object)6, (Object)((Object)snowballTargetTask));
        return Lists.newArrayList((Object[])new Pair[]{beg, supplemented, snowballFight});
    }

    private boolean canSnowballFight(EntityMaid maid) {
        World world = maid.field_70170_p;
        BlockPos pos = maid.func_233580_cy_();
        return !maid.isBegging() && world.func_226691_t_(pos).func_225486_c(pos) < 0.15f && world.func_180495_p(pos).func_203425_a(Blocks.field_150433_aE);
    }

    private Optional<? extends LivingEntity> findFirstValidSnowballTarget(EntityMaid maid) {
        return maid.func_213375_cj().func_218207_c(MemoryModuleType.field_220946_g).flatMap(mobs -> mobs.stream().filter(e -> this.isSnowballTarget((LivingEntity)e, maid)).filter(e -> maid.func_213389_a(e.func_233580_cy_())).findFirst());
    }

    private boolean isSnowballTarget(LivingEntity entity, EntityMaid maid) {
        if (maid.func_152114_e(entity)) {
            return true;
        }
        if (entity instanceof EntityMaid && maid.func_70902_q() != null) {
            EntityMaid maidOther = (EntityMaid)entity;
            return maid.func_70902_q().equals((Object)maidOther.func_70902_q());
        }
        return false;
    }
}

