/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.EmptyBlockReader;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class TaskNormalFarm
implements IFarmTask {
    private static final ResourceLocation NAME = new ResourceLocation("touhou_little_maid", "farm");

    @Override
    public ResourceLocation getUid() {
        return NAME;
    }

    @Override
    public ItemStack getIcon() {
        return Items.field_151019_K.func_190903_i();
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        BlockNamedItem blockNamedItem;
        Block block;
        Item item = stack.func_77973_b();
        if (item == Items.field_151075_bm) {
            return true;
        }
        if (item instanceof BlockNamedItem && (block = (blockNamedItem = (BlockNamedItem)item).func_179223_d()) instanceof IPlantable) {
            IPlantable plantable = (IPlantable)block;
            return plantable.getPlantType((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a) == PlantType.CROP && plantable.getPlant((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a).func_177230_c() != Blocks.field_150350_a;
        }
        return false;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        Block block = cropState.func_177230_c();
        if (block instanceof CropsBlock && ((CropsBlock)block).func_185525_y(cropState)) {
            return true;
        }
        return block == Blocks.field_150388_bm && (Integer)cropState.func_177229_b((Property)NetherWartBlock.field_176486_a) >= 3;
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        if (maid.func_184614_ca().func_77973_b() instanceof HoeItem) {
            maid.destroyBlock(cropPos);
        } else {
            Block cropBlock = cropState.func_177230_c();
            if (cropBlock instanceof CropsBlock) {
                CropsBlock crop = (CropsBlock)cropBlock;
                TileEntity blockEntity = cropState.hasTileEntity() ? maid.field_70170_p.func_175625_s(cropPos) : null;
                Block.func_220054_a((BlockState)cropState, (World)maid.field_70170_p, (BlockPos)cropPos, (TileEntity)blockEntity, (Entity)maid, (ItemStack)maid.func_184614_ca());
                maid.field_70170_p.func_180501_a(cropPos, crop.func_176223_P(), 3);
                return;
            }
            if (cropBlock == Blocks.field_150388_bm) {
                maid.field_70170_p.func_180501_a(cropPos, Blocks.field_150388_bm.func_176223_P(), 3);
                Block.func_180635_a((World)maid.field_70170_p, (BlockPos)cropPos, (ItemStack)new ItemStack((IItemProvider)Items.field_151075_bm));
            }
        }
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        BlockNamedItem blockNamedItem;
        Block block;
        BlockState aboveState = maid.field_70170_p.func_180495_p(basePos.func_177984_a());
        if (!aboveState.func_185904_a().func_76222_j() || aboveState.func_185904_a().func_76224_d()) {
            return false;
        }
        if (seed.func_77973_b() instanceof BlockNamedItem && (block = (blockNamedItem = (BlockNamedItem)seed.func_77973_b()).func_179223_d()) instanceof IPlantable) {
            IPlantable plantable = (IPlantable)block;
            return baseState.canSustainPlant((IBlockReader)maid.field_70170_p, basePos, Direction.UP, plantable);
        }
        return false;
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        BlockNamedItem blockNamedItem;
        Block block;
        if (seed.func_77973_b() instanceof BlockNamedItem && (block = (blockNamedItem = (BlockNamedItem)seed.func_77973_b()).func_179223_d()) instanceof IPlantable) {
            maid.placeItemBlock(basePos.func_177984_a(), seed);
        }
        return seed;
    }
}

