/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaskSugarCane
implements IFarmTask {
    private static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "sugar_cane");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.field_222065_kN.func_190903_i();
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        return stack.func_77973_b() == Items.field_222065_kN;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        BlockState blockDownState = maid.field_70170_p.func_180495_p(cropPos.func_177977_b());
        BlockState blockDown2State = maid.field_70170_p.func_180495_p(cropPos.func_177979_c(2));
        return cropState.func_203425_a(Blocks.field_196608_cF) && blockDownState.func_203425_a(Blocks.field_196608_cF) && this.canSustainSugarCane(blockDown2State);
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        maid.destroyBlock(cropPos);
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        World world = maid.field_70170_p;
        BlockPos cropPos = basePos.func_177984_a();
        if (!world.func_180495_p(cropPos).func_185904_a().func_76222_j() || world.func_180495_p(cropPos).func_185904_a().func_76224_d()) {
            return false;
        }
        return this.canSustainSugarCane(baseState) && this.hasWaterSourceBlock(maid.field_70170_p, basePos);
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        if (seed.func_77973_b() == Items.field_222065_kN) {
            maid.placeItemBlock(basePos.func_177984_a(), seed);
        }
        return seed;
    }

    @Override
    public double getCloseEnoughDist() {
        return 2.0;
    }

    private boolean canSustainSugarCane(BlockState state) {
        return state.func_203425_a(Blocks.field_196658_i) || state.func_203425_a(Blocks.field_150346_d) || state.func_203425_a(Blocks.field_196660_k) || state.func_203425_a(Blocks.field_196661_l) || state.func_203425_a(Blocks.field_150354_m) || state.func_203425_a(Blocks.field_196611_F) || state.func_235714_a_((ITag)BlockTags.field_203436_u);
    }

    private boolean hasWaterSourceBlock(World world, BlockPos basePos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState offsetState = world.func_180495_p(basePos.func_177972_a(direction));
            FluidState fluidState = world.func_204610_c(basePos.func_177972_a(direction));
            if (!fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && !offsetState.func_203425_a(Blocks.field_185778_de)) continue;
            return true;
        }
        return false;
    }
}

