/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager.AnimationData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager.AnimationFactory;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class SingletonAnimationFactory
extends AnimationFactory {
    private final Cache<Integer, AnimationData> animationDataMap = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();

    public SingletonAnimationFactory(IAnimatable animatable) {
        super(animatable);
    }

    @Override
    public AnimationData getOrCreateAnimationData(int uniqueID) {
        try {
            return (AnimationData)this.animationDataMap.get((Object)uniqueID, () -> {
                AnimationData data = new AnimationData();
                this.animatable.registerControllers(data);
                this.animationDataMap.put((Object)uniqueID, (Object)data);
                return data;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

