/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatableModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Color;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoCube;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.GeoModelProvider;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.AnimationUtils;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.EModelRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.IRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.LightType;

public abstract class GeoEntityRenderer<T extends LivingEntity>
extends EntityRenderer<T>
implements IGeoRenderer<T> {
    protected final AnimatedGeoModel<T> modelProvider;
    protected final List<GeoLayerRenderer<T>> layerRenderers = new ObjectArrayList();
    public ItemStack mainHand;
    public ItemStack offHand;
    public ItemStack helmet;
    public ItemStack chestplate;
    public ItemStack leggings;
    public ItemStack boots;
    public IRenderTypeBuffer rtb;
    public ResourceLocation whTexture;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected T animatable;
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;

    public GeoEntityRenderer(EntityRendererManager renderManager, AnimatedGeoModel<T> modelProvider) {
        super(renderManager);
        this.modelProvider = modelProvider;
    }

    private static float getFacingAngle(Direction direction) {
        switch (direction) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    private static void renderLeashPiece(IVertexBuilder buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)MathHelper.func_219799_g((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)MathHelper.func_219799_g((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.func_228451_a_((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.func_227888_a_(positionMatrix, x - xOffset, y + yOffset, z + zOffset).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(packedLight).func_181675_d();
        buffer.func_227888_a_(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(packedLight).func_181675_d();
    }

    @Override
    @Nonnull
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    @Override
    public void renderEarly(T animatable, MatrixStack poseStack, float partialTick, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float partialTicks) {
        this.animatable = animatable;
        this.renderEarlyMat = poseStack.func_227866_c_().func_227870_a_().func_226601_d_();
        this.rtb = bufferSource;
        this.whTexture = this.getTextureLocation(animatable);
        this.mainHand = animatable.func_184582_a(EquipmentSlotType.MAINHAND);
        this.offHand = animatable.func_184582_a(EquipmentSlotType.OFFHAND);
        this.helmet = animatable.func_184582_a(EquipmentSlotType.HEAD);
        this.chestplate = animatable.func_184582_a(EquipmentSlotType.CHEST);
        this.leggings = animatable.func_184582_a(EquipmentSlotType.LEGS);
        this.boots = animatable.func_184582_a(EquipmentSlotType.FEET);
        IGeoRenderer.super.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, partialTicks);
    }

    public void render(T animatable, float entityYaw, float partialTick, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int packedLight) {
        Direction bedDirection;
        MobEntity mob;
        Entity leashHolder;
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        poseStack.func_227860_a_();
        if (animatable instanceof MobEntity && (leashHolder = (mob = (MobEntity)animatable).func_110166_bE()) != null) {
            this.renderLeash(animatable, partialTick, poseStack, bufferSource, leashHolder);
        }
        this.dispatchedMat = poseStack.func_227866_c_().func_227870_a_().func_226601_d_();
        boolean shouldSit = animatable.func_184218_aH() && animatable.func_184187_bx() != null && animatable.func_184187_bx().shouldRiderSit();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = animatable.func_70631_g_();
        float lerpBodyRot = MathHelper.func_219805_h((float)partialTick, (float)((LivingEntity)animatable).field_70760_ar, (float)((LivingEntity)animatable).field_70761_aq);
        float lerpHeadRot = MathHelper.func_219805_h((float)partialTick, (float)((LivingEntity)animatable).field_70758_at, (float)((LivingEntity)animatable).field_70759_as);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && animatable.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)animatable.func_184187_bx();
            lerpBodyRot = MathHelper.func_219805_h((float)partialTick, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (animatable.func_213283_Z() == Pose.SLEEPING && (bedDirection = animatable.func_213376_dz()) != null) {
            float eyePosOffset = animatable.func_213307_e(Pose.STANDING) - 0.1f;
            poseStack.func_227861_a_((double)((float)(-bedDirection.func_82601_c()) * eyePosOffset), 0.0, (double)((float)(-bedDirection.func_82599_e()) * eyePosOffset));
        }
        float ageInTicks = (float)((LivingEntity)animatable).field_70173_aa + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (!shouldSit && animatable.func_70089_S()) {
            limbSwingAmount = MathHelper.func_219799_g((float)partialTick, (float)((LivingEntity)animatable).field_184618_aE, (float)((LivingEntity)animatable).field_70721_aZ);
            limbSwing = ((LivingEntity)animatable).field_184619_aG - ((LivingEntity)animatable).field_70721_aZ * (1.0f - partialTick);
            if (animatable.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        float headPitch = MathHelper.func_219799_g((float)partialTick, (float)((LivingEntity)animatable).field_70127_C, (float)((LivingEntity)animatable).field_70125_A);
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -netHeadYaw;
        AnimationEvent<IAnimatable> predicate = new AnimationEvent<IAnimatable>((IAnimatable)animatable, limbSwing, limbSwingAmount, partialTick, limbSwingAmount <= -this.getSwingMotionAniMathHelperreshold() || limbSwingAmount > this.getSwingMotionAniMathHelperreshold(), Collections.singletonList(entityModelData));
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(animatable));
        this.modelProvider.setCustomAnimations((IAnimatable)animatable, this.getInstanceId(animatable), predicate);
        poseStack.func_227861_a_(0.0, (double)0.01f, 0.0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTextureLocation(animatable));
        Color renderColor = this.getRenderColor(animatable, partialTick, poseStack, bufferSource, null, packedLight);
        RenderType renderType = this.getRenderType(animatable, partialTick, poseStack, bufferSource, null, packedLight, this.getTextureLocation(animatable));
        if (Minecraft.func_71410_x().field_71439_g != null && !animatable.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            IVertexBuilder translucentBuffer = bufferSource.getBuffer(RenderType.func_228642_d_((ResourceLocation)this.getTextureLocation(animatable)));
            this.render(model, animatable, partialTick, renderType, poseStack, bufferSource, translucentBuffer, packedLight, this.getOverlay(animatable, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        if (!animatable.func_175149_v()) {
            for (GeoLayerRenderer<T> layerRenderer : this.layerRenderers) {
                this.renderLayer(poseStack, bufferSource, packedLight, animatable, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch, bufferSource, layerRenderer);
            }
        }
        poseStack.func_227865_b_();
        super.func_225623_a_(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    @Override
    public void renderRecursively(GeoBone bone, MatrixStack poseStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        boolean rotOverride;
        poseStack.func_227860_a_();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        boolean bl = rotOverride = bone.rotMat != null;
        if (rotOverride) {
            poseStack.func_227866_c_().func_227870_a_().func_226595_a_(bone.rotMat);
            poseStack.func_227866_c_().func_227872_b_().func_226118_b_(new Matrix3f(bone.rotMat));
        } else {
            RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        }
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingXform()) {
            Matrix4f poseState = poseStack.func_227866_c_().func_227870_a_().func_226601_d_();
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.dispatchedMat);
            bone.setModelSpaceXform(RenderUtils.invertAndMultiplyMatrices(poseState, this.renderEarlyMat));
            localMatrix.func_226597_a_(new Vector3f(this.func_225627_b_((Entity)this.animatable, 1.0f)));
            bone.setLocalSpaceXform(localMatrix);
            Matrix4f worldState = localMatrix.func_226601_d_();
            worldState.func_226597_a_(new Vector3f(this.animatable.func_213303_ch()));
            bone.setWorldSpaceXform(worldState);
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        if (!bone.isHidden) {
            if (!bone.cubesAreHidden()) {
                for (GeoCube geoCube : bone.childCubes) {
                    poseStack.func_227860_a_();
                    this.renderCube(geoCube, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    poseStack.func_227865_b_();
                }
            }
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(childBone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        poseStack.func_227865_b_();
    }

    protected void renderLayer(MatrixStack poseStack, IRenderTypeBuffer bufferSource, int packedLight, T animatable, float limbSwing, float limbSwingAmount, float partialTick, float rotFloat, float netHeadYaw, float headPitch, IRenderTypeBuffer bufferSource2, GeoLayerRenderer<T> layerRenderer) {
        layerRenderer.render(poseStack, bufferSource, packedLight, animatable, limbSwing, limbSwingAmount, partialTick, rotFloat, netHeadYaw, headPitch);
    }

    @Override
    public int getInstanceId(T animatable) {
        return animatable.func_145782_y();
    }

    @Override
    public GeoModelProvider<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    @Override
    public float getWidthScale(T animatable) {
        return this.widthScale;
    }

    @Override
    public float getHeightScale(T entity) {
        return this.heightScale;
    }

    public int getOverlay(T entity, float u) {
        return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)u), (int)OverlayTexture.func_229202_a_((((LivingEntity)entity).field_70737_aN > 0 || ((LivingEntity)entity).field_70725_aQ > 0 ? 1 : 0) != 0));
    }

    protected void applyRotations(T animatable, MatrixStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        Pose pose = animatable.func_213283_Z();
        if (pose != Pose.SLEEPING) {
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        }
        if (((LivingEntity)animatable).field_70725_aQ > 0) {
            float deathRotation = ((float)((LivingEntity)animatable).field_70725_aQ + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(Math.min(MathHelper.func_76129_c((float)deathRotation), 1.0f) * this.getDeathMaxRotation(animatable)));
        } else if (animatable.func_204805_cN()) {
            poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f - ((LivingEntity)animatable).field_70125_A));
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)((LivingEntity)animatable).field_70173_aa + partialTick) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction bedOrientation = animatable.func_213376_dz();
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(bedOrientation != null ? GeoEntityRenderer.getFacingAngle(bedOrientation) : rotationYaw));
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.getDeathMaxRotation(animatable)));
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        } else if (animatable.func_145818_k_() || animatable instanceof PlayerEntity) {
            String name = animatable.func_200200_C_().getString();
            if (animatable instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)animatable;
                if (!player.func_175148_a(PlayerModelPart.CAPE)) {
                    return;
                }
            } else {
                name = TextFormatting.func_110646_a((String)name);
            }
            if (name != null && ("Dinnerbone".equals(name) || "Grumm".equalsIgnoreCase(name))) {
                poseStack.func_227861_a_(0.0, (double)(animatable.func_213302_cg() + 0.1f), 0.0);
                poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            }
        }
    }

    protected boolean isVisible(T animatable) {
        return !animatable.func_82150_aj();
    }

    protected float getDeathMaxRotation(T animatable) {
        return 90.0f;
    }

    public boolean shouldShowName(T animatable) {
        double nameRenderDistance;
        double d = nameRenderDistance = animatable.func_226273_bm_() ? 32.0 : 64.0;
        if (this.field_76990_c.func_229099_b_(animatable) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        return animatable == this.field_76990_c.field_147941_i && animatable.func_145818_k_() && Minecraft.func_71382_s();
    }

    protected float getSwingProgress(T animatable, float partialTick) {
        return animatable.func_70678_g(partialTick);
    }

    protected float getSwingMotionAniMathHelperreshold() {
        return 0.15f;
    }

    @Override
    public ResourceLocation getTextureLocation(T animatable) {
        return this.modelProvider.getTextureLocation(animatable);
    }

    public final boolean addLayer(GeoLayerRenderer<T> layer) {
        return this.layerRenderers.add(layer);
    }

    public <E extends Entity> void renderLeash(T entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffer, E leashHolder) {
        int u;
        poseStack.func_227860_a_();
        Vector3d vec3d = leashHolder.func_241843_o(partialTicks);
        double d = (double)(MathHelper.func_219799_g((float)partialTicks, (float)((LivingEntity)entity).field_70761_aq, (float)((LivingEntity)entity).field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vec3d2 = entity.func_241205_ce_();
        double e = Math.cos(d) * vec3d2.field_72449_c + Math.sin(d) * vec3d2.field_72450_a;
        double f = Math.sin(d) * vec3d2.field_72449_c - Math.cos(d) * vec3d2.field_72450_a;
        double g = MathHelper.func_219803_d((double)partialTicks, (double)((LivingEntity)entity).field_70169_q, (double)entity.func_226277_ct_()) + e;
        double h = MathHelper.func_219803_d((double)partialTicks, (double)((LivingEntity)entity).field_70167_r, (double)entity.func_226278_cu_()) + vec3d2.field_72448_b;
        double i = MathHelper.func_219803_d((double)partialTicks, (double)((LivingEntity)entity).field_70166_s, (double)entity.func_226281_cx_()) + f;
        poseStack.func_227861_a_(e, vec3d2.field_72448_b, f);
        float j = (float)(vec3d.field_72450_a - g);
        float k = (float)(vec3d.field_72448_b - h);
        float l = (float)(vec3d.field_72449_c - i);
        IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
        float n = MathHelper.func_226165_i_((float)(j * j + l * l)) * 0.025f / 2.0f;
        float o = l * n;
        float p = j * n;
        BlockPos blockPos = new BlockPos(entity.func_174824_e(partialTicks));
        BlockPos blockPos2 = new BlockPos(leashHolder.func_174824_e(partialTicks));
        int q = this.func_225624_a_((Entity)entity, blockPos);
        int r = leashHolder.func_70027_ad() ? 15 : leashHolder.field_70170_p.func_226658_a_(LightType.BLOCK, blockPos2);
        int s = ((LivingEntity)entity).field_70170_p.func_226658_a_(LightType.SKY, blockPos);
        int t = ((LivingEntity)entity).field_70170_p.func_226658_a_(LightType.SKY, blockPos2);
        for (u = 0; u <= 24; ++u) {
            GeoEntityRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.025f, o, p, u, false);
        }
        for (u = 24; u >= 0; --u) {
            GeoEntityRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.0f, o, p, u, true);
        }
        poseStack.func_227865_b_();
    }

    @Override
    public IRenderTypeBuffer getCurrentRTB() {
        return this.rtb;
    }

    @Override
    public void setCurrentRTB(IRenderTypeBuffer bufferSource) {
        this.rtb = bufferSource;
    }

    static {
        AnimationController.addModelFetcher(animatable -> animatable instanceof Entity ? (IAnimatableModel)((Object)AnimationUtils.getGeoModelForEntity((Entity)animatable)) : null);
    }
}

