/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.GeoModelProvider;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public abstract class GeoLayerRenderer<T extends Entity> {
    protected final IGeoRenderer<T> entityRenderer;

    public GeoLayerRenderer(IGeoRenderer<T> entityRendererIn) {
        this.entityRenderer = entityRendererIn;
    }

    protected void renderCopyModel(GeoModelProvider<T> modelProvider, ResourceLocation texture, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int packedLight, T animatable, float partialTick, float red, float green, float blue) {
        if (!animatable.func_82150_aj()) {
            this.renderModel(modelProvider, texture, poseStack, bufferSource, packedLight, animatable, partialTick, red, green, blue);
        }
    }

    protected void renderModel(GeoModelProvider<T> modelProvider, ResourceLocation texture, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int packedLight, T animatable, float partialTick, float red, float green, float blue) {
        if (animatable instanceof LivingEntity) {
            RenderType renderType = this.getRenderType(texture);
            LivingEntity entity = (LivingEntity)animatable;
            this.getRenderer().render(modelProvider.getModel(modelProvider.getModelLocation(animatable)), animatable, partialTick, renderType, poseStack, bufferSource, bufferSource.getBuffer(renderType), packedLight, LivingRenderer.func_229117_c_((LivingEntity)entity, (float)0.0f), red, green, blue, 1.0f);
        }
    }

    public RenderType getRenderType(ResourceLocation textureLocation) {
        return RenderType.func_228638_b_((ResourceLocation)textureLocation);
    }

    public GeoModelProvider<T> getEntityModel() {
        return this.entityRenderer.getGeoModelProvider();
    }

    public IGeoRenderer<T> getRenderer() {
        return this.entityRenderer;
    }

    protected ResourceLocation getEntityTexture(T entityIn) {
        return this.entityRenderer.getTextureLocation(entityIn);
    }

    public abstract void render(MatrixStack var1, IRenderTypeBuffer var2, int var3, T var4, float var5, float var6, float var7, float var8, float var9, float var10);
}

