/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Color;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.EModelRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.IRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.LightType;

public abstract class GeoReplacedEntityRenderer<T extends IAnimatable>
extends EntityRenderer
implements IGeoRenderer {
    protected static final Map<Class<? extends IAnimatable>, GeoReplacedEntityRenderer> renderers = new ConcurrentHashMap<Class<? extends IAnimatable>, GeoReplacedEntityRenderer>();
    protected final AnimatedGeoModel<IAnimatable> modelProvider;
    protected final List<GeoLayerRenderer> layerRenderers = new ObjectArrayList();
    protected T animatable;
    protected IAnimatable currentAnimatable;
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected IRenderTypeBuffer rtb = null;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;

    public GeoReplacedEntityRenderer(EntityRendererManager renderManager, AnimatedGeoModel<IAnimatable> modelProvider, T animatable) {
        super(renderManager);
        this.modelProvider = modelProvider;
        this.animatable = animatable;
        renderers.putIfAbsent(animatable.getClass(), this);
    }

    public static GeoReplacedEntityRenderer getRenderer(Class<? extends IAnimatable> animatableClass) {
        return renderers.get(animatableClass);
    }

    public static int getPackedOverlay(LivingEntity entity, float u) {
        return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)u), (int)OverlayTexture.func_229202_a_((entity.field_70737_aN > 0 || entity.field_70725_aQ > 0 ? 1 : 0) != 0));
    }

    private static float getFacingAngle(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    private static void renderLeashPiece(IVertexBuilder buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)MathHelper.func_219799_g((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)MathHelper.func_219799_g((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.func_228451_a_((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.func_227888_a_(positionMatrix, x - xOffset, y + yOffset, z + zOffset).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(packedLight).func_181675_d();
        buffer.func_227888_a_(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(packedLight).func_181675_d();
    }

    @Override
    @Nonnull
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    public float getWidthScale(Object animatable) {
        return this.widthScale;
    }

    public float getHeightScale(Object entity) {
        return this.heightScale;
    }

    public void renderEarly(Object animatable, MatrixStack poseStack, float partialTick, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, int packedLight, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderEarlyMat = poseStack.func_227866_c_().func_227870_a_().func_226601_d_();
        IGeoRenderer.super.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlayIn, red, green, blue, alpha);
    }

    public void func_225623_a_(Entity entity, float entityYaw, float partialTick, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int packedLight) {
        this.render(entity, (IAnimatable)this.animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void render(Entity entity, IAnimatable animatable, float entityYaw, float partialTick, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int packedLight) {
        Direction direction;
        MobEntity mob;
        Entity leashHolder;
        if (!(entity instanceof LivingEntity)) {
            throw new IllegalStateException("Replaced renderer was not an instanceof LivingEntity");
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        this.currentAnimatable = animatable;
        this.dispatchedMat = poseStack.func_227866_c_().func_227870_a_().func_226601_d_();
        boolean shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        poseStack.func_227860_a_();
        if (entity instanceof MobEntity && (leashHolder = (mob = (MobEntity)entity).func_110166_bE()) != null) {
            this.renderLeash(mob, partialTick, poseStack, bufferSource, leashHolder);
        }
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = livingEntity.func_70631_g_();
        float lerpBodyRot = MathHelper.func_219805_h((float)partialTick, (float)livingEntity.field_70760_ar, (float)livingEntity.field_70761_aq);
        float lerpHeadRot = MathHelper.func_219805_h((float)partialTick, (float)livingEntity.field_70758_at, (float)livingEntity.field_70759_as);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && entity.func_184187_bx() instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity.func_184187_bx();
            lerpBodyRot = MathHelper.func_219805_h((float)partialTick, (float)vehicle.field_70760_ar, (float)vehicle.field_70761_aq);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (entity.func_213283_Z() == Pose.SLEEPING && (direction = livingEntity.func_213376_dz()) != null) {
            float eyeOffset = entity.func_213307_e(Pose.STANDING) - 0.1f;
            poseStack.func_227861_a_((double)((float)(-direction.func_82601_c()) * eyeOffset), 0.0, (double)((float)(-direction.func_82599_e()) * eyeOffset));
        }
        float lerpedAge = (float)livingEntity.field_70173_aa + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.applyRotations(livingEntity, poseStack, lerpedAge, lerpBodyRot, partialTick);
        this.preRenderCallback(livingEntity, poseStack, partialTick);
        if (!shouldSit && entity.func_70089_S()) {
            limbSwingAmount = Math.min(1.0f, MathHelper.func_219799_g((float)partialTick, (float)livingEntity.field_184618_aE, (float)livingEntity.field_70721_aZ));
            limbSwing = livingEntity.field_184619_aG - livingEntity.field_70721_aZ * (1.0f - partialTick);
            if (livingEntity.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
        }
        float headPitch = MathHelper.func_219799_g((float)partialTick, (float)entity.field_70127_C, (float)entity.field_70125_A);
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)netHeadYaw), (float)-85.0f, (float)85.0f);
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(animatable));
        AnimationEvent<IAnimatable> predicate = new AnimationEvent<IAnimatable>(animatable, limbSwing, limbSwingAmount, partialTick, limbSwingAmount <= -this.getSwingMotionAniMathHelperreshold() || limbSwingAmount <= this.getSwingMotionAniMathHelperreshold(), Collections.singletonList(entityModelData));
        this.modelProvider.setCustomAnimations(animatable, this.getInstanceId(entity), predicate);
        poseStack.func_227861_a_(0.0, (double)0.01f, 0.0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.func_110775_a(entity));
        Color renderColor = this.getRenderColor(animatable, partialTick, poseStack, bufferSource, null, packedLight);
        RenderType renderType = this.getRenderType(entity, partialTick, poseStack, bufferSource, null, packedLight, this.func_110775_a(entity));
        if (Minecraft.func_71410_x().field_71439_g != null && !entity.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            IVertexBuilder translucentBuffer = bufferSource.getBuffer(RenderType.func_228642_d_((ResourceLocation)this.func_110775_a(entity)));
            this.render(model, entity, partialTick, renderType, poseStack, bufferSource, translucentBuffer, packedLight, GeoReplacedEntityRenderer.getPackedOverlay(livingEntity, this.getOverlayProgress(livingEntity, partialTick)), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        if (!entity.func_175149_v()) {
            for (GeoLayerRenderer layerRenderer : this.layerRenderers) {
                layerRenderer.render(poseStack, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTick, lerpedAge, netHeadYaw, headPitch);
            }
        }
        poseStack.func_227865_b_();
        super.func_225623_a_(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    @Override
    public void renderRecursively(GeoBone bone, MatrixStack poseStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingXform()) {
            Entity entity = (Entity)this.animatable;
            Matrix4f poseState = poseStack.func_227866_c_().func_227870_a_().func_226601_d_();
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.dispatchedMat);
            bone.setModelSpaceXform(RenderUtils.invertAndMultiplyMatrices(poseState, this.renderEarlyMat));
            localMatrix.func_226597_a_(new Vector3f(this.func_225627_b_(entity, 1.0f)));
            bone.setLocalSpaceXform(localMatrix);
            Matrix4f worldState = localMatrix.func_226601_d_();
            worldState.func_226597_a_(new Vector3f(entity.func_213303_ch()));
            bone.setWorldSpaceXform(worldState);
        }
        IGeoRenderer.super.renderRecursively(bone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected float getOverlayProgress(LivingEntity entity, float partialTicks) {
        return 0.0f;
    }

    protected void preRenderCallback(LivingEntity entity, MatrixStack poseStack, float partialTick) {
    }

    public ResourceLocation func_110775_a(Entity entity) {
        return this.modelProvider.getTextureLocation(this.currentAnimatable);
    }

    @Override
    public AnimatedGeoModel getGeoModelProvider() {
        return this.modelProvider;
    }

    protected void applyRotations(LivingEntity entity, MatrixStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        Pose pose = entity.func_213283_Z();
        if (pose != Pose.SLEEPING) {
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        }
        if (pose == Pose.SLEEPING) {
            Direction bedOrientation = entity.func_213376_dz();
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(bedOrientation != null ? GeoReplacedEntityRenderer.getFacingAngle(bedOrientation) : rotationYaw));
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.getDeathMaxRotation(entity)));
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
            poseStack.func_227861_a_(0.0, -0.25, 0.0);
        } else if (entity.func_145818_k_() || entity instanceof PlayerEntity) {
            String name = entity.func_200200_C_().getString();
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                if (!player.func_175148_a(PlayerModelPart.CAPE)) {
                    return;
                }
            } else {
                name = TextFormatting.func_110646_a((String)name);
            }
            if (name != null && ("Dinnerbone".equals(name) || "Grumm".equalsIgnoreCase(name))) {
                poseStack.func_227861_a_(0.0, (double)(entity.func_213302_cg() + 0.1f), 0.0);
                poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            }
        }
    }

    protected boolean isVisible(LivingEntity entity) {
        return !entity.func_82150_aj();
    }

    protected float getDeathMaxRotation(LivingEntity entity) {
        return 90.0f;
    }

    public boolean func_177070_b(Entity entity) {
        double nameRenderDistance;
        double d = nameRenderDistance = entity.func_226273_bm_() ? 32.0 : 64.0;
        if (this.field_76990_c.func_229099_b_(entity) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        return entity == this.field_76990_c.field_147941_i && entity.func_145818_k_() && Minecraft.func_71382_s();
    }

    protected float getSwingProgress(LivingEntity entity, float partialTick) {
        return entity.func_70678_g(partialTick);
    }

    protected float getSwingMotionAniMathHelperreshold() {
        return 0.15f;
    }

    public ResourceLocation getTextureLocation(Object animatable) {
        return this.modelProvider.getTextureLocation((IAnimatable)animatable);
    }

    public final boolean addLayer(GeoLayerRenderer<? extends LivingEntity> layer) {
        return this.layerRenderers.add(layer);
    }

    public <E extends Entity> void renderLeash(MobEntity entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffer, E leashHolder) {
        int u;
        poseStack.func_227860_a_();
        Vector3d vec3d = leashHolder.func_241843_o(partialTicks);
        double d = (double)(MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70761_aq, (float)entity.field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vec3d2 = entity.func_241205_ce_();
        double e = Math.cos(d) * vec3d2.field_72449_c + Math.sin(d) * vec3d2.field_72450_a;
        double f = Math.sin(d) * vec3d2.field_72449_c - Math.cos(d) * vec3d2.field_72450_a;
        double g = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70169_q, (double)entity.func_226277_ct_()) + e;
        double h = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70167_r, (double)entity.func_226278_cu_()) + vec3d2.field_72448_b;
        double i = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70166_s, (double)entity.func_226281_cx_()) + f;
        poseStack.func_227861_a_(e, vec3d2.field_72448_b, f);
        float j = (float)(vec3d.field_72450_a - g);
        float k = (float)(vec3d.field_72448_b - h);
        float l = (float)(vec3d.field_72449_c - i);
        IVertexBuilder vertexConsumer = buffer.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
        float n = MathHelper.func_226165_i_((float)(j * j + l * l)) * 0.025f / 2.0f;
        float o = l * n;
        float p = j * n;
        BlockPos blockPos = new BlockPos(entity.func_174824_e(partialTicks));
        BlockPos blockPos2 = new BlockPos(leashHolder.func_174824_e(partialTicks));
        int q = this.func_225624_a_((Entity)entity, blockPos);
        int r = leashHolder.func_70027_ad() ? 15 : leashHolder.field_70170_p.func_226658_a_(LightType.BLOCK, blockPos2);
        int s = entity.field_70170_p.func_226658_a_(LightType.SKY, blockPos);
        int t = entity.field_70170_p.func_226658_a_(LightType.SKY, blockPos2);
        for (u = 0; u <= 24; ++u) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.025f, o, p, u, false);
        }
        for (u = 24; u >= 0; --u) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.0f, o, p, u, true);
        }
        poseStack.func_227865_b_();
    }

    @Override
    public IRenderTypeBuffer getCurrentRTB() {
        return this.rtb;
    }

    @Override
    public void setCurrentRTB(IRenderTypeBuffer bufferSource) {
        this.rtb = bufferSource;
    }

    static {
        AnimationController.addModelFetcher(object -> {
            GeoReplacedEntityRenderer renderer = renderers.get(object.getClass());
            return renderer == null ? null : renderer.getGeoModelProvider();
        });
    }
}

