/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Color;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoCube;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoQuad;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoVertex;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.GeoModelProvider;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.EModelRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.IRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;

public interface IGeoRenderer<T> {
    public static final String GLOW_PREFIX = "ysmGlow";

    public IRenderTypeBuffer getCurrentRTB();

    default public void setCurrentRTB(IRenderTypeBuffer bufferSource) {
    }

    public GeoModelProvider getGeoModelProvider();

    public ResourceLocation getTextureLocation(T var1);

    @Nullable
    default public GeoModel getGeoModel() {
        return null;
    }

    default public void render(GeoModel model, T animatable, float partialTick, RenderType type, MatrixStack poseStack, @Nullable IRenderTypeBuffer bufferSource, @Nullable IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.setCurrentRTB(bufferSource);
        this.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (bufferSource != null) {
            buffer = bufferSource.getBuffer(type);
        }
        this.renderLate(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        for (GeoBone group : model.topLevelBones) {
            this.renderRecursively(group, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        this.setCurrentModelRenderCycle(EModelRenderCycle.REPEATED);
    }

    default public void renderRecursively(GeoBone bone, MatrixStack poseStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        int cubePackedLight = packedLight;
        if (bone.getName().startsWith(GLOW_PREFIX)) {
            cubePackedLight = LightTexture.func_228451_a_((int)15, (int)15);
        }
        poseStack.func_227860_a_();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(bone, poseStack, buffer, cubePackedLight, packedOverlay, red, green, blue, alpha);
        this.renderChildBones(bone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.func_227865_b_();
    }

    default public void renderCubesOfBone(GeoBone bone, MatrixStack poseStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isHidden()) {
            return;
        }
        for (GeoCube cube : bone.childCubes) {
            if (bone.cubesAreHidden()) continue;
            poseStack.func_227860_a_();
            this.renderCube(cube, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.func_227865_b_();
        }
    }

    default public void renderChildBones(GeoBone bone, MatrixStack poseStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.childBonesAreHiddenToo()) {
            return;
        }
        for (GeoBone childBone : bone.childBones) {
            this.renderRecursively(childBone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    default public void renderCube(GeoCube cube, MatrixStack poseStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.func_227866_c_().func_227872_b_();
        Matrix4f poseState = poseStack.func_227866_c_().func_227870_a_();
        for (GeoQuad quad : cube.quads) {
            if (quad == null) continue;
            Vector3f normal = quad.normal.func_229195_e_();
            normal.func_229188_a_(normalisedPoseState);
            if ((cube.size.func_195900_b() == 0.0f || cube.size.func_195902_c() == 0.0f) && normal.func_195899_a() < 0.0f) {
                normal.func_229192_b_(-1.0f, 1.0f, 1.0f);
            }
            if ((cube.size.func_195899_a() == 0.0f || cube.size.func_195902_c() == 0.0f) && normal.func_195900_b() < 0.0f) {
                normal.func_229192_b_(1.0f, -1.0f, 1.0f);
            }
            if ((cube.size.func_195899_a() == 0.0f || cube.size.func_195900_b() == 0.0f) && normal.func_195902_c() < 0.0f) {
                normal.func_229192_b_(1.0f, 1.0f, -1.0f);
            }
            this.createVerticesOfQuad(quad, poseState, normal, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    default public void createVerticesOfQuad(GeoQuad quad, Matrix4f poseState, Vector3f normal, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (GeoVertex vertex : quad.vertices) {
            Vector4f vector4f = new Vector4f(vertex.position.func_195899_a(), vertex.position.func_195900_b(), vertex.position.func_195902_c(), 1.0f);
            vector4f.func_229372_a_(poseState);
            buffer.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), red, green, blue, alpha, vertex.textureU, vertex.textureV, packedOverlay, packedLight, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c());
        }
    }

    default public void renderEarly(T animatable, MatrixStack poseStack, float partialTick, @Nullable IRenderTypeBuffer bufferSource, @Nullable IVertexBuilder buffer, int packedLight, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.getCurrentModelRenderCycle() == EModelRenderCycle.INITIAL) {
            float width = this.getWidthScale(animatable);
            float height = this.getHeightScale(animatable);
            poseStack.func_227862_a_(width, height, width);
        }
    }

    default public void renderLate(T animatable, MatrixStack poseStack, float partialTick, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    default public RenderType getRenderType(T animatable, float partialTick, MatrixStack poseStack, @Nullable IRenderTypeBuffer bufferSource, @Nullable IVertexBuilder buffer, int packedLight, ResourceLocation texture) {
        return RenderType.func_228638_b_((ResourceLocation)texture);
    }

    default public Color getRenderColor(T animatable, float partialTick, MatrixStack poseStack, @Nullable IRenderTypeBuffer bufferSource, @Nullable IVertexBuilder buffer, int packedLight) {
        return Color.WHITE;
    }

    default public int getInstanceId(T animatable) {
        return animatable.hashCode();
    }

    @Nonnull
    default public IRenderCycle getCurrentModelRenderCycle() {
        return EModelRenderCycle.INITIAL;
    }

    default public void setCurrentModelRenderCycle(IRenderCycle cycle) {
    }

    default public float getWidthScale(T animatable) {
        return 1.0f;
    }

    default public float getHeightScale(T entity) {
        return 1.0f;
    }
}

