/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.Cube;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.FaceUv;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.ModelProperties;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.UvFaces;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.UvUnion;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoQuad;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoVertex;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.VectorUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class GeoCube {
    public GeoQuad[] quads = new GeoQuad[6];
    public Vector3f pivot;
    public Vector3f rotation;
    public Vector3f size = new Vector3f();
    public double inflate;
    public Boolean mirror;

    private GeoCube(double[] size) {
        if (size.length >= 3) {
            this.size.func_195905_a((float)size[0], (float)size[1], (float)size[2]);
        }
    }

    public static GeoCube createFromPojoCube(Cube cubeIn, ModelProperties properties, Double boneInflate, Boolean mirror) {
        GeoQuad quadDown;
        GeoQuad quadUp;
        GeoQuad quadSouth;
        GeoQuad quadNorth;
        GeoQuad quadEast;
        GeoQuad quadWest;
        GeoCube cube = new GeoCube(cubeIn.getSize());
        UvUnion uvUnion = cubeIn.getUv();
        UvFaces faces = uvUnion.faceUV;
        boolean isBoxUV = uvUnion.isBoxUV;
        cube.mirror = cubeIn.getMirror();
        cube.inflate = cubeIn.getInflate() == null ? (boneInflate == null ? 0.0 : boneInflate) : cubeIn.getInflate() / 16.0;
        float textureHeight = properties.getTextureHeight().floatValue();
        float textureWidth = properties.getTextureWidth().floatValue();
        Vector3d size = VectorUtils.fromArray(cubeIn.getSize());
        Vector3d origin = VectorUtils.fromArray(cubeIn.getOrigin());
        origin = new Vector3d(-(origin.field_72450_a + size.field_72450_a) / 16.0, origin.field_72448_b / 16.0, origin.field_72449_c / 16.0);
        size = size.func_216372_d(0.0625, 0.0625, 0.0625);
        Vector3f rotation = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(cubeIn.getRotation()));
        rotation.func_229192_b_(-1.0f, -1.0f, 1.0f);
        rotation.setX((float)Math.toRadians(rotation.func_195899_a()));
        rotation.setY((float)Math.toRadians(rotation.func_195900_b()));
        rotation.setZ((float)Math.toRadians(rotation.func_195902_c()));
        Vector3f pivot = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(cubeIn.getPivot()));
        pivot.func_229192_b_(-1.0f, 1.0f, 1.0f);
        cube.pivot = pivot;
        cube.rotation = rotation;
        GeoVertex P1 = new GeoVertex(origin.field_72450_a - cube.inflate, origin.field_72448_b - cube.inflate, origin.field_72449_c - cube.inflate);
        GeoVertex P2 = new GeoVertex(origin.field_72450_a - cube.inflate, origin.field_72448_b - cube.inflate, origin.field_72449_c + size.field_72449_c + cube.inflate);
        GeoVertex P3 = new GeoVertex(origin.field_72450_a - cube.inflate, origin.field_72448_b + size.field_72448_b + cube.inflate, origin.field_72449_c - cube.inflate);
        GeoVertex P4 = new GeoVertex(origin.field_72450_a - cube.inflate, origin.field_72448_b + size.field_72448_b + cube.inflate, origin.field_72449_c + size.field_72449_c + cube.inflate);
        GeoVertex P5 = new GeoVertex(origin.field_72450_a + size.field_72450_a + cube.inflate, origin.field_72448_b - cube.inflate, origin.field_72449_c - cube.inflate);
        GeoVertex P6 = new GeoVertex(origin.field_72450_a + size.field_72450_a + cube.inflate, origin.field_72448_b - cube.inflate, origin.field_72449_c + size.field_72449_c + cube.inflate);
        GeoVertex P7 = new GeoVertex(origin.field_72450_a + size.field_72450_a + cube.inflate, origin.field_72448_b + size.field_72448_b + cube.inflate, origin.field_72449_c - cube.inflate);
        GeoVertex P8 = new GeoVertex(origin.field_72450_a + size.field_72450_a + cube.inflate, origin.field_72448_b + size.field_72448_b + cube.inflate, origin.field_72449_c + size.field_72449_c + cube.inflate);
        if (!isBoxUV) {
            FaceUv west = faces.getWest();
            FaceUv east = faces.getEast();
            FaceUv north = faces.getNorth();
            FaceUv south = faces.getSouth();
            FaceUv up = faces.getUp();
            FaceUv down = faces.getDown();
            quadWest = west == null ? null : new GeoQuad(new GeoVertex[]{P4, P3, P1, P2}, west.getUv(), west.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.WEST);
            quadEast = east == null ? null : new GeoQuad(new GeoVertex[]{P7, P8, P6, P5}, east.getUv(), east.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.EAST);
            quadNorth = north == null ? null : new GeoQuad(new GeoVertex[]{P3, P7, P5, P1}, north.getUv(), north.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.NORTH);
            quadSouth = south == null ? null : new GeoQuad(new GeoVertex[]{P8, P4, P2, P6}, south.getUv(), south.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.SOUTH);
            quadUp = up == null ? null : new GeoQuad(new GeoVertex[]{P4, P8, P7, P3}, up.getUv(), up.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.UP);
            GeoQuad geoQuad = quadDown = down == null ? null : new GeoQuad(new GeoVertex[]{P1, P5, P6, P2}, down.getUv(), down.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.DOWN);
            if (Boolean.TRUE.equals(cubeIn.getMirror()) || Boolean.TRUE.equals(mirror)) {
                quadWest = west == null ? null : new GeoQuad(new GeoVertex[]{P7, P8, P6, P5}, west.getUv(), west.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.WEST);
                quadEast = east == null ? null : new GeoQuad(new GeoVertex[]{P4, P3, P1, P2}, east.getUv(), east.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.EAST);
                quadNorth = north == null ? null : new GeoQuad(new GeoVertex[]{P3, P7, P5, P1}, north.getUv(), north.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.NORTH);
                quadSouth = south == null ? null : new GeoQuad(new GeoVertex[]{P8, P4, P2, P6}, south.getUv(), south.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.SOUTH);
                quadUp = up == null ? null : new GeoQuad(new GeoVertex[]{P1, P5, P6, P2}, up.getUv(), up.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.UP);
                quadDown = down == null ? null : new GeoQuad(new GeoVertex[]{P4, P8, P7, P3}, down.getUv(), down.getUvSize(), textureWidth, textureHeight, cubeIn.getMirror(), Direction.DOWN);
            }
        } else {
            double[] uv = cubeIn.getUv().boxUVCoords;
            Vector3d uvSize = VectorUtils.fromArray(cubeIn.getSize());
            uvSize = new Vector3d(Math.floor(uvSize.field_72450_a), Math.floor(uvSize.field_72448_b), Math.floor(uvSize.field_72449_c));
            quadWest = new GeoQuad(new GeoVertex[]{P4, P3, P1, P2}, new double[]{uv[0] + uvSize.field_72449_c + uvSize.field_72450_a, uv[1] + uvSize.field_72449_c}, new double[]{uvSize.field_72449_c, uvSize.field_72448_b}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.WEST);
            quadEast = new GeoQuad(new GeoVertex[]{P7, P8, P6, P5}, new double[]{uv[0], uv[1] + uvSize.field_72449_c}, new double[]{uvSize.field_72449_c, uvSize.field_72448_b}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.EAST);
            quadNorth = new GeoQuad(new GeoVertex[]{P3, P7, P5, P1}, new double[]{uv[0] + uvSize.field_72449_c, uv[1] + uvSize.field_72449_c}, new double[]{uvSize.field_72450_a, uvSize.field_72448_b}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.NORTH);
            quadSouth = new GeoQuad(new GeoVertex[]{P8, P4, P2, P6}, new double[]{uv[0] + uvSize.field_72449_c + uvSize.field_72450_a + uvSize.field_72449_c, uv[1] + uvSize.field_72449_c}, new double[]{uvSize.field_72450_a, uvSize.field_72448_b}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.SOUTH);
            quadUp = new GeoQuad(new GeoVertex[]{P4, P8, P7, P3}, new double[]{uv[0] + uvSize.field_72449_c, uv[1]}, new double[]{uvSize.field_72450_a, uvSize.field_72449_c}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.UP);
            quadDown = new GeoQuad(new GeoVertex[]{P1, P5, P6, P2}, new double[]{uv[0] + uvSize.field_72449_c + uvSize.field_72450_a, uv[1] + uvSize.field_72449_c}, new double[]{uvSize.field_72450_a, -uvSize.field_72449_c}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.DOWN);
            if (Boolean.TRUE.equals(cubeIn.getMirror()) || Boolean.TRUE.equals(mirror)) {
                quadWest = new GeoQuad(new GeoVertex[]{P7, P8, P6, P5}, new double[]{uv[0] + uvSize.field_72449_c + uvSize.field_72450_a, uv[1] + uvSize.field_72449_c}, new double[]{uvSize.field_72449_c, uvSize.field_72448_b}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.WEST);
                quadEast = new GeoQuad(new GeoVertex[]{P4, P3, P1, P2}, new double[]{uv[0], uv[1] + uvSize.field_72449_c}, new double[]{uvSize.field_72449_c, uvSize.field_72448_b}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.EAST);
                quadNorth = new GeoQuad(new GeoVertex[]{P3, P7, P5, P1}, new double[]{uv[0] + uvSize.field_72449_c, uv[1] + uvSize.field_72449_c}, new double[]{uvSize.field_72450_a, uvSize.field_72448_b}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.NORTH);
                quadSouth = new GeoQuad(new GeoVertex[]{P8, P4, P2, P6}, new double[]{uv[0] + uvSize.field_72449_c + uvSize.field_72450_a + uvSize.field_72449_c, uv[1] + uvSize.field_72449_c}, new double[]{uvSize.field_72450_a, uvSize.field_72448_b}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.SOUTH);
                quadUp = new GeoQuad(new GeoVertex[]{P4, P8, P7, P3}, new double[]{uv[0] + uvSize.field_72449_c, uv[1]}, new double[]{uvSize.field_72450_a, uvSize.field_72449_c}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.UP);
                quadDown = new GeoQuad(new GeoVertex[]{P1, P5, P6, P2}, new double[]{uv[0] + uvSize.field_72449_c + uvSize.field_72450_a, uv[1] + uvSize.field_72449_c}, new double[]{uvSize.field_72450_a, -uvSize.field_72449_c}, textureWidth, textureHeight, cubeIn.getMirror(), Direction.DOWN);
            }
        }
        cube.quads[0] = quadWest;
        cube.quads[1] = quadEast;
        cube.quads[2] = quadNorth;
        cube.quads[3] = quadSouth;
        cube.quads[4] = quadUp;
        cube.quads[5] = quadDown;
        return cube;
    }
}

