/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.init.registry;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class MobSpawnInfoRegistry {
    private static MobSpawnInfo.Spawners SPAWNER_DATA;

    @SubscribeEvent
    public static void addMobSpawnInfo(BiomeLoadingEvent event) {
        if (MobSpawnInfoRegistry.biomeIsOkay(event.getCategory())) {
            List spawnerData = event.getSpawns().getSpawner(EntityClassification.MONSTER);
            boolean canZombieSpawn = spawnerData.stream().anyMatch(data -> data.field_242588_c.equals(EntityType.field_200725_aD));
            if (SPAWNER_DATA == null) {
                SPAWNER_DATA = new MobSpawnInfo.Spawners((EntityType)InitEntities.FAIRY.get(), ((Integer)MiscConfig.MAID_FAIRY_SPAWN_PROBABILITY.get()).intValue(), 2, 4);
            }
            if (canZombieSpawn) {
                event.getSpawns().func_242575_a(EntityClassification.MONSTER, SPAWNER_DATA);
            }
        }
    }

    private static boolean biomeIsOkay(Biome.Category category) {
        return !((List)MiscConfig.MAID_FAIRY_BLACKLIST_BIOME.get()).contains(category.func_222352_a());
    }
}

