/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container;

import com.github.tartaricacid.touhoulittlemaid.client.event.ReloadResourceEvent;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class MaidMainContainer
extends AbstractMaidContainer {
    protected static final int PLAYER_INVENTORY_SIZE = 36;
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{PlayerContainer.field_226619_g_, PlayerContainer.field_226618_f_, PlayerContainer.field_226617_e_, PlayerContainer.field_226616_d_};
    private static final EquipmentSlotType[] SLOT_IDS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};

    public MaidMainContainer(ContainerType<?> type, int id, PlayerInventory inventory, int entityId) {
        super(type, id, inventory, entityId);
        if (this.maid != null) {
            this.addMaidArmorInv();
            this.addMaidBauble();
            this.addMaidHandInv();
            this.addMainDefaultInv();
            this.addBackpackInv(inventory);
        }
    }

    private void addMaidHandInv() {
        LazyOptional hand = this.maid.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN);
        hand.ifPresent(handler -> this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)handler, 0, 87, 77){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)ReloadResourceEvent.EMPTY_MAINHAND_SLOT);
            }
        }));
        hand.ifPresent(handler -> this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)handler, 1, 121, 77){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
            }
        }));
    }

    private void addMaidArmorInv() {
        LazyOptional armor = this.maid.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST);
        armor.ifPresent(handler -> {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    final EquipmentSlotType equipmentSlotType = SLOT_IDS[2 * i + j];
                    this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)handler, 3 - 2 * i - j, 94 + 20 * j, 37 + 20 * i){

                        public int func_75219_a() {
                            return 1;
                        }

                        public boolean func_75214_a(@Nonnull ItemStack stack) {
                            return stack.canEquip(equipmentSlotType, (Entity)MaidMainContainer.this.maid);
                        }

                        public boolean func_82869_a(PlayerEntity playerIn) {
                            ItemStack itemstack = this.func_75211_c();
                            boolean curseEnchant = !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack);
                            return !curseEnchant && super.func_82869_a(playerIn);
                        }

                        @OnlyIn(value=Dist.CLIENT)
                        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                            return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)TEXTURE_EMPTY_SLOTS[equipmentSlotType.func_188454_b()]);
                        }
                    });
                }
            }
        });
    }

    private void addMainDefaultInv() {
        ItemStackHandler inv = this.maid.getMaidInv();
        for (int i = 0; i < 6; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inv, i, 143 + 18 * i, 37));
            if (i != 5) continue;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inv, i, 143 + 18 * i, 37){

                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)ReloadResourceEvent.EMPTY_BACK_SHOW_SLOT);
                }
            });
        }
    }

    protected abstract void addBackpackInv(PlayerInventory var1);

    private void addMaidBauble() {
        BaubleItemHandler maidBauble = this.maid.getMaidBauble();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)maidBauble, i * 3 + j, 86 + 18 * j, 99 + 18 * i));
            }
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack stack1 = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack2 = slot.func_75211_c();
            stack1 = stack2.func_77946_l();
            if (index < 36 ? !this.func_75135_a(stack2, 36, this.field_75151_b.size(), false) : !this.func_75135_a(stack2, 0, 36, true)) {
                return ItemStack.field_190927_a;
            }
            if (stack2.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack1;
    }
}

