/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class WirelessIOContainer
extends Container {
    public static final ContainerType<WirelessIOContainer> TYPE = IForgeContainerType.create((windowId, inv, data) -> new WirelessIOContainer(windowId, inv, data.func_150791_c()));
    private final ItemStack wirelessIO;
    private final ItemStackHandler filterListInv;

    public WirelessIOContainer(int id, PlayerInventory inventory, ItemStack wirelessIO) {
        super(TYPE, id);
        this.wirelessIO = wirelessIO;
        this.filterListInv = ItemWirelessIO.getFilterList(wirelessIO);
        this.addPlayerSlots(inventory);
        this.addWirelessIOSlots();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return playerIn.func_184614_ca().func_77973_b() == InitItems.WIRELESS_IO.get();
    }

    public ItemStack func_184996_a(int slotId, int button, ClickType clickTypeIn, PlayerEntity player) {
        if (slotId == 27 + player.field_71071_by.field_70461_c) {
            return player.field_71071_by.func_70301_a(slotId);
        }
        if (clickTypeIn == ClickType.SWAP) {
            return player.field_71071_by.func_70301_a(slotId);
        }
        ItemStack stack = super.func_184996_a(slotId, button, clickTypeIn, player);
        ItemWirelessIO.setFilterList(this.wirelessIO, this.filterListInv);
        return stack;
    }

    private void addWirelessIOSlots() {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.func_75146_a((Slot)new WirelessIOSlotItemHandler((IItemHandler)this.filterListInv, col + row * 3, 62 + col * 18, 17 + row * 18));
            }
        }
    }

    private void addPlayerSlots(PlayerInventory inventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)inventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)inventory, col, 8 + col * 18, 142));
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack stack1 = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack2 = slot.func_75211_c();
            stack1 = stack2.func_77946_l();
            if (index < 36 ? !this.func_75135_a(stack2, 27, 36, true) : !this.func_75135_a(stack2, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack2.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return stack1;
    }

    public ItemStack getWirelessIO() {
        return this.wirelessIO;
    }

    private class WirelessIOSlotItemHandler
    extends SlotItemHandler {
        private WirelessIOSlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public int func_75219_a() {
            return 1;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return EntityMaid.canInsertItem(stack) && super.func_75214_a(stack);
        }
    }
}

