/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.FurnaceBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.FurnaceResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IIntArray;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class FurnaceBackpackContainer
extends MaidMainContainer {
    public static final ContainerType<FurnaceBackpackContainer> TYPE = IForgeContainerType.create((windowId, inv, data) -> new FurnaceBackpackContainer(windowId, inv, data.readInt()));
    private final IIntArray data;

    public FurnaceBackpackContainer(int id, PlayerInventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        FurnaceBackpackData furnaceData = this.getMaid().getBackpackData() instanceof FurnaceBackpackData ? (FurnaceBackpackData)this.getMaid().getBackpackData() : new FurnaceBackpackData(this.getMaid());
        this.data = furnaceData.getDataAccess();
        this.func_75146_a(new Slot((IInventory)furnaceData, 0, 161, 101){

            public boolean func_75214_a(ItemStack stack) {
                return EntityMaid.canInsertItem(stack);
            }
        });
        this.func_75146_a(new FurnaceBackpackFuelSlot(this, (IInventory)furnaceData, 1, 161, 142));
        this.func_75146_a((Slot)new FurnaceResultSlot(inventory.field_70458_d, (IInventory)furnaceData, 2, 221, 121));
        this.func_216961_a(this.data);
    }

    @Override
    protected void addBackpackInv(PlayerInventory inventory) {
        int i;
        ItemStackHandler itemHandler = this.maid.getMaidInv();
        for (i = 0; i < 6; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)itemHandler, 6 + i, 143 + 18 * i, 57));
        }
        for (i = 0; i < 6; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)itemHandler, 12 + i, 143 + 18 * i, 75));
        }
    }

    private boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, (IRecipeType)IRecipeType.field_222150_b) > 0;
    }

    public int getBurnProgress() {
        int cookingProgress = this.data.func_221476_a(2);
        int cookingTotalTime = this.data.func_221476_a(3);
        return cookingTotalTime != 0 && cookingProgress != 0 ? cookingProgress * 24 / cookingTotalTime : 0;
    }

    public int getLitProgress() {
        int litDuration = this.data.func_221476_a(1);
        if (litDuration == 0) {
            litDuration = 200;
        }
        return this.data.func_221476_a(0) * 13 / litDuration;
    }

    public boolean isLit() {
        return this.data.func_221476_a(0) > 0;
    }

    public static class FurnaceBackpackFuelSlot
    extends Slot {
        private final FurnaceBackpackContainer furnaceBackpackContainer;

        public FurnaceBackpackFuelSlot(FurnaceBackpackContainer furnaceBackpackContainer, IInventory container, int slot, int pX, int pY) {
            super(container, slot, pX, pY);
            this.furnaceBackpackContainer = furnaceBackpackContainer;
        }

        public static boolean isBucket(ItemStack stack) {
            return stack.func_77973_b() == Items.field_151133_ar;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.furnaceBackpackContainer.isFuel(stack) || FurnaceBackpackFuelSlot.isBucket(stack);
        }

        public int func_178170_b(ItemStack stack) {
            return FurnaceBackpackFuelSlot.isBucket(stack) ? 1 : super.func_178170_b(stack);
        }
    }
}

