/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.TankBackpackData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.mojang.datafixers.util.Pair;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class TankBackpackContainer
extends MaidMainContainer {
    public static final ContainerType<TankBackpackContainer> TYPE = IForgeContainerType.create((windowId, inv, data) -> new TankBackpackContainer(windowId, inv, data.readInt()));
    private static final ResourceLocation INPUT_SLOT = new ResourceLocation("touhou_little_maid", "slot/tank_input_slot");
    private static final ResourceLocation OUTPUT_SLOT = new ResourceLocation("touhou_little_maid", "slot/tank_output_slot");
    private final IIntArray data;

    public TankBackpackContainer(int id, PlayerInventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        TankBackpackData tankData = this.getMaid().getBackpackData() instanceof TankBackpackData ? (TankBackpackData)this.getMaid().getBackpackData() : new TankBackpackData(this.getMaid());
        this.data = tankData.getDataAccess();
        this.func_75146_a(new TankInputSlot((IInventory)tankData, 0, 161, 101));
        this.func_75146_a(new TankOutputSlot((IInventory)tankData, 1, 161, 140));
        this.func_216961_a(this.data);
    }

    @Override
    protected void addBackpackInv(PlayerInventory inventory) {
        int i;
        ItemStackHandler itemHandler = this.maid.getMaidInv();
        for (i = 0; i < 6; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)itemHandler, 6 + i, 143 + 18 * i, 57));
        }
        for (i = 0; i < 6; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)itemHandler, 12 + i, 143 + 18 * i, 75));
        }
    }

    public int getFluidCount() {
        return this.data.func_221476_a(0);
    }

    public static class TankOutputSlot
    extends Slot {
        public TankOutputSlot(IInventory pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean func_75214_a(ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
        }

        @OnlyIn(value=Dist.CLIENT)
        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
            return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)OUTPUT_SLOT);
        }
    }

    public static class TankInputSlot
    extends Slot {
        public TankInputSlot(IInventory pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean func_75214_a(ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
        }

        @OnlyIn(value=Dist.CLIENT)
        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
            return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)INPUT_SLOT);
        }
    }
}

